"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findInvestigationsResponseSchema = exports.findInvestigationsParamsSchema = void 0;
var _zod = require("@kbn/zod");
var _investigation = require("./investigation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findInvestigationsParamsSchema = exports.findInvestigationsParamsSchema = _zod.z.object({
  query: _zod.z.object({
    alertId: _zod.z.string(),
    search: _zod.z.string(),
    filter: _zod.z.string(),
    page: _zod.z.coerce.number(),
    perPage: _zod.z.coerce.number()
  }).partial()
}).partial();
const findInvestigationsResponseSchema = exports.findInvestigationsResponseSchema = _zod.z.object({
  page: _zod.z.number(),
  perPage: _zod.z.number(),
  total: _zod.z.number(),
  results: _zod.z.array(_investigation.investigationResponseSchema)
});