"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigatePlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _item_definition_registry = require("./investigation/item_definition_registry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class InvestigatePlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "itemDefinitionRegistry", new _item_definition_registry.ItemDefinitionRegistry());
  }
  setup(coreSetup, pluginsSetup) {
    return {
      registerItemDefinition: definition => {
        this.itemDefinitionRegistry.registerItem(definition);
      }
    };
  }
  start(coreStart, pluginsStart) {
    return {
      getItemDefinitions: () => this.itemDefinitionRegistry.getItemDefinitions(),
      getItemDefinitionByType: type => this.itemDefinitionRegistry.getItemDefinitionByType(type)
    };
  }
}
exports.InvestigatePlugin = InvestigatePlugin;