"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateInvestigation = updateInvestigation;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function updateInvestigation(investigationId, params, {
  repository,
  user
}) {
  const originalInvestigation = await repository.findById(investigationId);
  const updatedInvestigation = Object.assign({}, originalInvestigation, params, {
    updatedAt: Date.now()
  });
  if ((0, _lodash.isEqual)((0, _lodash.omit)(originalInvestigation, ['updatedAt']), (0, _lodash.omit)(updatedInvestigation, ['updatedAt']))) {
    return originalInvestigation;
  }
  await repository.save(updatedInvestigation);
  return updatedInvestigation;
}