"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.excludeFrozenQuery = excludeFrozenQuery;
exports.rangeQuery = rangeQuery;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function rangeQuery(start, end, field = '@timestamp') {
  return [{
    range: {
      [field]: {
        gte: start,
        lte: end,
        format: 'epoch_millis'
      }
    }
  }];
}
function excludeFrozenQuery() {
  return [{
    bool: {
      must_not: [{
        term: {
          _tier: 'data_frozen'
        }
      }]
    }
  }];
}