"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createEsqlService = createEsqlService;
var _common = require("@kbn/data-plugin/common");
var _esqlUtils = require("@kbn/esql-utils");
var _common2 = require("@kbn/kibana-utils-plugin/common");
var _rxjs = require("rxjs");
var _uuid = require("uuid");
var _get_kibana_columns = require("../utils/get_kibana_columns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createEsqlService({
  data,
  dataViews,
  lens
}) {
  async function runQuery({
    query,
    signal,
    dropNullColumns = true,
    filter
  }) {
    const response = await (0, _rxjs.lastValueFrom)(data.search.search({
      params: {
        query,
        dropNullColumns,
        filter
      }
    }, {
      strategy: _common.ESQL_SEARCH_STRATEGY,
      abortSignal: signal
    })).then(searchResponse => {
      return searchResponse.rawResponse;
    });
    return response;
  }
  const esql = {
    query: async ({
      query,
      signal,
      filter
    }) => {
      return await runQuery({
        query,
        signal,
        filter
      });
    },
    queryWithMeta: async ({
      query,
      signal,
      filter
    }) => {
      const [meta, queryResult] = await Promise.all([esql.meta({
        query,
        signal,
        filter
      }), esql.query({
        query,
        signal,
        filter
      })]);
      return {
        query: queryResult,
        meta
      };
    },
    meta: async ({
      query,
      signal,
      filter
    }) => {
      var _response$columns, _suggestionsFromLensH;
      const [response, lensHelper, dataView] = await Promise.all([runQuery({
        query: `${query} | LIMIT 0`,
        signal,
        dropNullColumns: false,
        filter
      }), lens.stateHelperApi(), (0, _esqlUtils.getESQLAdHocDataview)(query, dataViews)]);
      const columns = (0, _get_kibana_columns.getKibanaColumns)((_response$columns = response.columns) !== null && _response$columns !== void 0 ? _response$columns : []);
      const suggestionsFromLensHelper = await lensHelper.suggestions({
        dataViewSpec: dataView.toSpec(false),
        fieldName: '',
        textBasedColumns: columns,
        query: {
          esql: query
        }
      }, dataView);
      if (signal.aborted) {
        throw new _common2.AbortError();
      }
      return {
        columns,
        suggestions: (_suggestionsFromLensH = suggestionsFromLensHelper === null || suggestionsFromLensHelper === void 0 ? void 0 : suggestionsFromLensHelper.map(suggestion => ({
          id: (0, _uuid.v4)(),
          ...suggestion
        }))) !== null && _suggestionsFromLensH !== void 0 ? _suggestionsFromLensH : [],
        dataView
      };
    }
  };
  return esql;
}