"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TagsFilter = TagsFilter;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_fetch_all_investigation_tags = require("../../../../hooks/use_fetch_all_investigation_tags");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TAGS_LABEL = _i18n.i18n.translate('xpack.investigateApp.searchBar.tagsFilterButtonLabel', {
  defaultMessage: 'Tags'
});
function TagsFilter({
  isLoading,
  onChange
}) {
  const {
    isLoading: isTagsLoading,
    data: tags
  } = (0, _use_fetch_all_investigation_tags.useFetchAllInvestigationTags)();
  const [items, setItems] = (0, _react.useState)([]);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const filterTagsPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'filterTagsPopover'
  });
  (0, _react.useEffect)(() => {
    if (tags) {
      setItems(tags.map(tag => ({
        label: tag
      })));
    }
  }, [tags]);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    iconType: "arrowDown",
    badgeColor: "success",
    onClick: () => setIsPopoverOpen(!isPopoverOpen),
    isSelected: isPopoverOpen,
    numFilters: items.length,
    hasActiveFilters: !!items.find(item => item.checked === 'on'),
    numActiveFilters: items.filter(item => item.checked === 'on').length
  }, TAGS_LABEL);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: filterTagsPopoverId,
    button: button,
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    searchable: true,
    searchProps: {
      compressed: true
    },
    "aria-label": TAGS_LABEL,
    options: items,
    onChange: newOptions => {
      setItems(newOptions);
      onChange(newOptions.filter(item => item.checked === 'on').map(item => item.label));
    },
    isLoading: isLoading || isTagsLoading
  }, (list, search) => /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s"
  }, search), list))));
}