"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigationContext = void 0;
exports.InvestigationProvider = InvestigationProvider;
exports.useInvestigation = useInvestigation;
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _use_add_investigation_item = require("../../../hooks/use_add_investigation_item");
var _use_delete_investigation_item = require("../../../hooks/use_delete_investigation_item");
var _use_fetch_alert = require("../../../hooks/use_fetch_alert");
var _use_fetch_investigation = require("../../../hooks/use_fetch_investigation");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_update_investigation = require("../../../hooks/use_update_investigation");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InvestigationContext = exports.InvestigationContext = /*#__PURE__*/(0, _react.createContext)({
  renderableItems: [],
  globalParams: {
    timeRange: {
      from: '',
      to: ''
    }
  },
  investigation: undefined,
  updateInvestigationParams: async () => {},
  addItem: async () => {},
  deleteItem: async () => {},
  isAddingItem: false,
  isDeletingItem: false
});
function useInvestigation() {
  return (0, _react.useContext)(InvestigationContext);
}
function InvestigationProvider({
  initialInvestigation,
  children
}) {
  const {
    dependencies: {
      start: {
        investigate
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    data: investigation,
    refetch
  } = (0, _use_fetch_investigation.useFetchInvestigation)({
    id: initialInvestigation.id,
    initialInvestigation
  });
  const {
    data: alert
  } = (0, _use_fetch_alert.useFetchAlert)({
    investigation
  });
  const cache = (0, _react.useRef)({});
  const {
    mutateAsync: updateInvestigation
  } = (0, _use_update_investigation.useUpdateInvestigation)();
  const {
    mutateAsync: addInvestigationItem,
    isLoading: isAddingItem
  } = (0, _use_add_investigation_item.useAddInvestigationItem)();
  const {
    mutateAsync: deleteInvestigationItem,
    isLoading: isDeletingItem
  } = (0, _use_delete_investigation_item.useDeleteInvestigationItem)();
  const [renderableItems, setRenderableItems] = (0, _react.useState)([]);
  const [globalParams, setGlobalParams] = (0, _react.useState)({
    timeRange: {
      from: new Date(initialInvestigation.params.timeRange.from).toISOString(),
      to: new Date(initialInvestigation.params.timeRange.to).toISOString()
    }
  });
  const updateInvestigationParams = async nextGlobalParams => {
    const timeRange = {
      from: new Date(nextGlobalParams.timeRange.from).getTime(),
      to: new Date(nextGlobalParams.timeRange.to).getTime()
    };
    await updateInvestigation({
      investigationId: initialInvestigation.id,
      payload: {
        params: {
          timeRange
        }
      }
    });
    setGlobalParams(nextGlobalParams);
  };
  const addItem = async item => {
    await addInvestigationItem({
      investigationId: initialInvestigation.id,
      item
    });
    refetch();
  };
  const deleteItem = async itemId => {
    await deleteInvestigationItem({
      investigationId: initialInvestigation.id,
      itemId
    });
    refetch();
  };
  (0, _react.useEffect)(() => {
    async function renderItems(currItems) {
      return await Promise.all(currItems.map(async item => {
        var _cache$current;
        const itemDefinition = investigate.getItemDefinitionByType(item.type);
        if (!itemDefinition) {
          return Promise.resolve({
            ...item,
            loading: false,
            element: /*#__PURE__*/_react.default.createElement("div", null, _i18n.i18n.translate('xpack.investigateApp.renderableItems.div.notFoundLabel', {
              defaultMessage: 'Not found for type {type}',
              values: {
                type: item.type
              }
            }))
          });
        }
        const cacheItem = (_cache$current = cache.current) === null || _cache$current === void 0 ? void 0 : _cache$current[item.id];
        if (cacheItem && (0, _lodash.isEqual)(cacheItem.globalParams, globalParams)) {
          return cacheItem.item;
        }
        const data = await itemDefinition.generate({
          itemParams: item.params,
          globalParams
        });
        const renderedItem = {
          ...item,
          loading: false,
          element: itemDefinition.render({
            data,
            globalParams,
            itemParams: item.params
          })
        };
        cache.current[item.id] = {
          globalParams,
          item: renderedItem
        };
        return renderedItem;
      }));
    }
    if (investigation !== null && investigation !== void 0 && investigation.items) {
      renderItems(investigation.items).then(nextRenderableItems => setRenderableItems(nextRenderableItems));
    }
  }, [investigation === null || investigation === void 0 ? void 0 : investigation.items, investigate, globalParams]);
  return /*#__PURE__*/_react.default.createElement(InvestigationContext.Provider, {
    value: {
      renderableItems,
      updateInvestigationParams,
      investigation,
      alert: alert !== null && alert !== void 0 ? alert : undefined,
      globalParams,
      addItem,
      deleteItem,
      isAddingItem,
      isDeletingItem
    }
  }, children);
}