"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Note = Note;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _dateFns = require("date-fns");
var _react = _interopRequireWildcard(require("react"));
var _use_theme = require("../../../../hooks/use_theme");
var _investigation_context = require("../../contexts/investigation_context");
var _edit_note_form = require("./edit_note_form");
var _use_delete_investigation_note = require("../../../../hooks/use_delete_investigation_note");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line import/no-extraneous-dependencies

const textContainerClassName = (0, _css.css)`
  padding-top: 2px;
`;
function Note({
  note,
  isOwner,
  userProfile,
  userProfileLoading
}) {
  var _ref, _userProfile$user$ful;
  const theme = (0, _use_theme.useTheme)();
  const [isEditing, setIsEditing] = (0, _react.useState)(false);
  const {
    investigation
  } = (0, _investigation_context.useInvestigation)();
  const {
    mutate: deleteNote,
    isLoading: isDeletingNote
  } = (0, _use_delete_investigation_note.useDeleteInvestigationNote)();
  const onDeleteNote = () => {
    deleteNote({
      investigationId: investigation.id,
      noteId: note.id
    });
  };
  const timelineContainerClassName = (0, _css.css)`
    padding-bottom: 16px;
    border-bottom: 1px solid ${theme.colors.lightShade};
    :last-child {
      border-bottom: 0px;
    }
  `;
  const actionButtonClassname = (0, _css.css)`
    color: ${theme.colors.mediumShade};
    :hover {
      color: ${theme.colors.darkShade};
    }
  `;
  const timestampClassName = (0, _css.css)`
    color: ${theme.colors.darkShade};
  `;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    className: timelineContainerClassName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, userProfileLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, (_ref = (_userProfile$user$ful = userProfile === null || userProfile === void 0 ? void 0 : userProfile.user.full_name) !== null && _userProfile$user$ful !== void 0 ? _userProfile$user$ful : userProfile === null || userProfile === void 0 ? void 0 : userProfile.user.username) !== null && _ref !== void 0 ? _ref : note === null || note === void 0 ? void 0 : note.createdBy)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    className: timestampClassName
  }, (0, _dateFns.formatDistance)(new Date(note.createdAt), new Date(), {
    addSuffix: true
  })))), isOwner && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "flexEnd",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "editInvestigationNoteButton",
    size: "s",
    iconSize: "s",
    iconType: "pencil",
    disabled: isDeletingNote,
    onClick: () => {
      setIsEditing(!isEditing);
    },
    className: actionButtonClassname
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    iconSize: "s",
    iconType: "trash",
    disabled: isDeletingNote,
    onClick: onDeleteNote,
    "data-test-subj": "deleteInvestigationNoteButton",
    className: actionButtonClassname
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: textContainerClassName
  }, isEditing ? /*#__PURE__*/_react.default.createElement(_edit_note_form.EditNoteForm, {
    note: note,
    onClose: () => setIsEditing(false)
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
    textSize: "s"
  }, note.content))));
}