"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigationItemsList = InvestigationItemsList;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _investigation_context = require("../../contexts/investigation_context");
var _grid_item = require("../grid_item");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function InvestigationItemsList() {
  const {
    renderableItems,
    addItem,
    deleteItem,
    isAddingItem,
    isDeletingItem
  } = (0, _investigation_context.useInvestigation)();
  if (!renderableItems.length) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    responsive: true
  }, renderableItems.map(item => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: `item-${item.id}`
    }, /*#__PURE__*/_react.default.createElement(_grid_item.GridItem, {
      id: item.id,
      title: item.title,
      loading: item.loading || isAddingItem || isDeletingItem,
      onCopy: async () => {
        await addItem((0, _lodash.pick)(item, ['title', 'type', 'params']));
      },
      onDelete: async () => {
        await deleteItem(item.id);
      }
    }, item.element));
  }));
}