"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigationDetails = InvestigationDetails;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _paths = require("../../../../../common/paths");
var _investigation_edit_form = require("../../../../components/investigation_edit_form/investigation_edit_form");
var _use_kibana = require("../../../../hooks/use_kibana");
var _investigation_context = require("../../contexts/investigation_context");
var _investigation_header = require("../investigation_header/investigation_header");
var _investigation_items = require("../investigation_items/investigation_items");
var _investigation_notes = require("../investigation_notes/investigation_notes");
var _use_screen_context = require("../../../../hooks/use_screen_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function InvestigationDetails({
  user
}) {
  const {
    core: {
      http: {
        basePath
      }
    },
    dependencies: {
      start: {
        observabilityShared
      }
    }
  } = (0, _use_kibana.useKibana)();
  (0, _use_screen_context.useScreenContext)();
  const ObservabilityPageTemplate = observabilityShared.navigation.PageTemplate;
  const {
    investigation
  } = (0, _investigation_context.useInvestigation)();
  const [isEditFormFlyoutVisible, setEditFormFlyoutVisible] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    pageHeader: {
      breadcrumbs: [{
        href: basePath.prepend(_paths.paths.investigations),
        text: _i18n.i18n.translate('xpack.investigateApp.detailsPage.breadcrumb.list', {
          defaultMessage: 'Investigations'
        })
      }, {
        text: _i18n.i18n.translate('xpack.investigateApp.detailsPage.breadcrumb.details', {
          defaultMessage: 'Investigation details'
        })
      }],
      pageTitle: /*#__PURE__*/_react.default.createElement(_investigation_header.InvestigationHeader, null),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        fill: true,
        "data-test-subj": "escalateButton"
      }, _i18n.i18n.translate('xpack.investigateApp.investigationDetails.escalateButtonLabel', {
        defaultMessage: 'Escalate'
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "editButton",
        fill: true,
        onClick: () => setEditFormFlyoutVisible(true)
      }, _i18n.i18n.translate('xpack.investigateApp.investigationDetails.editButtonLabel', {
        defaultMessage: 'Edit'
      }))]
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 4
  }, /*#__PURE__*/_react.default.createElement(_investigation_items.InvestigationItems, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_investigation_notes.InvestigationNotes, {
    user: user
  }))), isEditFormFlyoutVisible && investigation && /*#__PURE__*/_react.default.createElement(_investigation_edit_form.InvestigationEditForm, {
    investigationId: investigation.id,
    onClose: () => setEditFormFlyoutVisible(false)
  }));
}