"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GRID_ITEM_HEADER_HEIGHT = void 0;
exports.GridItem = GridItem;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _react = _interopRequireDefault(require("react"));
var _investigate_text_button = require("../../../../components/investigate_text_button");
var _use_theme = require("../../../../hooks/use_theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GRID_ITEM_HEADER_HEIGHT = exports.GRID_ITEM_HEADER_HEIGHT = 40;
const titleContainerClassName = (0, _css.css)`
  overflow: hidden;
`;
const titleItemClassName = (0, _css.css)`
  max-width: 100%;
  .euiText {
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
  }
`;
const panelClassName = (0, _css.css)`
  overflow-y: auto;
`;
const panelContentClassName = (0, _css.css)`
  overflow-y: auto;
  height: 100%;
`;
function GridItem({
  id,
  title,
  children,
  onDelete,
  onCopy,
  loading
}) {
  const theme = (0, _use_theme.useTheme)();
  const headerClassName = (0, _css.css)`
  padding: 0 ${theme.size.s} 0 ${theme.size.s}};
`;
  const containerClassName = (0, _css.css)`
    height: 100%;
    max-width: 100%;
    transition: opacity ${theme.animation.normal} ${theme.animation.resistance};
    overflow: auto;
  `;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    className: panelClassName,
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    className: containerClassName,
    alignItems: "stretch"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "none",
    alignItems: "center",
    className: headerClassName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: titleContainerClassName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    className: titleItemClassName
  }, /*#__PURE__*/_react.default.createElement("h5", null, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "gridItemControls"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "none",
    alignItems: "center",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_investigate_text_button.InvestigateTextButton, {
    iconType: "copy",
    onClick: () => {
      onCopy();
    },
    disabled: loading
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_investigate_text_button.InvestigateTextButton, {
    iconType: "trash",
    onClick: () => {
      onDelete();
    },
    disabled: loading
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: panelContentClassName
  }, children)));
}