"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssistantHypothesis = AssistantHypothesis;
var _i18n = require("@kbn/i18n");
var _technical_rule_data_field_names = require("@kbn/rule-registry-plugin/common/technical_rule_data_field_names");
var _serverRouteRepositoryClient = require("@kbn/server-route-repository-client");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _use_kibana = require("../../../../hooks/use_kibana");
var _use_update_investigation = require("../../../../hooks/use_update_investigation");
var _investigation_context = require("../../contexts/investigation_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AssistantHypothesis() {
  const {
    alert,
    globalParams: {
      timeRange
    },
    investigation
  } = (0, _investigation_context.useInvestigation)();
  const {
    core: {
      notifications
    },
    services: {
      investigateAppRepositoryClient
    },
    dependencies: {
      start: {
        observabilityAIAssistant: {
          useGenAIConnectors
        },
        observabilityAIAssistantApp: {
          RootCauseAnalysisContainer
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    mutateAsync: updateInvestigation
  } = (0, _use_update_investigation.useUpdateInvestigation)();
  const {
    loading: loadingConnector,
    selectedConnector
  } = useGenAIConnectors();
  const serviceName = alert === null || alert === void 0 ? void 0 : alert['service.name'];
  const [events, setEvents] = (0, _react.useState)([]);
  const [loading, setLoading] = (0, _react.useState)(false);
  const [error, setError] = (0, _react.useState)(undefined);
  const controllerRef = (0, _react.useRef)(new AbortController());
  (0, _react.useEffect)(() => {
    if (investigation !== null && investigation !== void 0 && investigation.rootCauseAnalysis) {
      setEvents(investigation.rootCauseAnalysis.events);
    }
  }, [investigation === null || investigation === void 0 ? void 0 : investigation.rootCauseAnalysis]);
  const [completeInBackground, setCompleteInBackground] = (0, _react.useState)(true);
  const runRootCauseAnalysis = ({
    alert: nonNullishAlert,
    connectorId,
    serviceName: nonNullishServiceName
  }) => {
    const rangeFrom = timeRange.from;
    const rangeTo = timeRange.to;
    setLoading(true);
    setError(undefined);
    setEvents([]);
    investigateAppRepositoryClient.stream('POST /internal/observability/investigation/root_cause_analysis', {
      params: {
        body: {
          investigationId: investigation.id,
          connectorId,
          context: `The user is investigating an alert for the ${serviceName} service,
            and wants to find the root cause. Here is the alert:

            ${JSON.stringify(sanitizeAlert(nonNullishAlert))}`,
          rangeFrom,
          rangeTo,
          serviceName: nonNullishServiceName,
          completeInBackground
        }
      },
      signal: controllerRef.current.signal
    }).subscribe({
      next: event => {
        setEvents(prev => {
          return prev.concat(event.event);
        });
      },
      error: nextError => {
        if (!(0, _serverRouteRepositoryClient.isRequestAbortedError)(nextError)) {
          notifications.toasts.addError(nextError, {
            title: _i18n.i18n.translate('xpack.investigateApp.assistantHypothesis.failedToLoadAnalysis', {
              defaultMessage: `Failed to load analysis`
            })
          });
          setError(nextError);
        } else {
          setError(new Error(_i18n.i18n.translate('xpack.investigateApp.assistantHypothesis.analysisAborted', {
            defaultMessage: `Analysis was aborted`
          })));
        }
        setLoading(false);
      },
      complete: () => {
        setLoading(false);
      }
    });
  };
  if (!serviceName) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(RootCauseAnalysisContainer, {
    events: events,
    loading: loading || loadingConnector,
    completeInBackground: completeInBackground,
    onCompleteInBackgroundClick: () => {
      setCompleteInBackground(() => !completeInBackground);
    },
    onStopAnalysisClick: () => {
      controllerRef.current.abort();
      controllerRef.current = new AbortController();
    },
    onClearAnalysisClick: () => {
      setEvents([]);
      if (investigation !== null && investigation !== void 0 && investigation.rootCauseAnalysis) {
        updateInvestigation({
          investigationId: investigation.id,
          payload: {
            rootCauseAnalysis: {
              events: []
            }
          }
        });
      }
    },
    onResetAnalysisClick: () => {
      controllerRef.current.abort();
      controllerRef.current = new AbortController();
      if (alert && selectedConnector && serviceName) {
        runRootCauseAnalysis({
          alert,
          connectorId: selectedConnector,
          serviceName
        });
      }
    },
    error: error,
    onStartAnalysisClick: () => {
      if (alert && selectedConnector && serviceName) {
        runRootCauseAnalysis({
          alert,
          connectorId: selectedConnector,
          serviceName
        });
      }
    }
  });
}
function sanitizeAlert(alert) {
  return (0, _lodash.omit)(alert, _technical_rule_data_field_names.ALERT_RULE_EXECUTION_TIMESTAMP, '_index', _technical_rule_data_field_names.ALERT_FLAPPING_HISTORY, _technical_rule_data_field_names.EVENT_ACTION, _technical_rule_data_field_names.EVENT_KIND, _technical_rule_data_field_names.ALERT_RULE_EXECUTION_UUID, '@timestamp');
}