"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EMBEDDABLE_ITEM_TYPE = void 0;
exports.registerEmbeddableItem = registerEmbeddableItem;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _public = require("@kbn/embeddable-plugin/public");
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMBEDDABLE_ITEM_TYPE = exports.EMBEDDABLE_ITEM_TYPE = 'embeddable';
const embeddableClassName = (0, _css.css)`
  height: 100%;
  > [data-shared-item] {
    height: 100%;
  }
`;
function ReactEmbeddable({
  type,
  config,
  timeRange: {
    from,
    to
  },
  savedObjectId
}) {
  const configWithOverrides = (0, _react.useMemo)(() => {
    return {
      ...config,
      timeRange: {
        from,
        to
      },
      savedObjectId
    };
  }, [config, from, to, savedObjectId]);
  const configWithOverridesRef = (0, _react.useRef)(configWithOverrides);
  configWithOverridesRef.current = configWithOverrides;
  const api = (0, _react.useMemo)(() => {
    return {
      getSerializedStateForChild: () => ({
        rawState: configWithOverridesRef.current
      })
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: embeddableClassName
  }, /*#__PURE__*/_react.default.createElement(_public.ReactEmbeddableRenderer, {
    type: type,
    getParentApi: () => api,
    maybeId: savedObjectId,
    hidePanelChrome: true
  }));
}
function registerEmbeddableItem({
  dependencies: {
    setup: {
      investigate
    }
  },
  services
}) {
  investigate.registerItemDefinition({
    type: EMBEDDABLE_ITEM_TYPE,
    generate: async option => {
      return {};
    },
    render: option => {
      const parameters = {
        type: option.itemParams.type,
        config: option.itemParams.config,
        savedObjectId: option.itemParams.savedObjectId,
        timeRange: option.globalParams.timeRange
      };
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: true,
        className: (0, _css.css)`
            > div {
              height: 128px;
            }
          `
      }, /*#__PURE__*/_react.default.createElement(ReactEmbeddable, parameters));
    }
  });
}