"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useScreenContext = useScreenContext;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _dedent = _interopRequireDefault(require("dedent"));
var _react = require("react");
var _use_kibana = require("./use_kibana");
var _investigation_context = require("../pages/details/contexts/investigation_context");
var _use_fetch_alert = require("./use_fetch_alert");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useScreenContext() {
  const {
    dependencies: {
      start: {
        observabilityAIAssistant
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    investigation
  } = (0, _investigation_context.useInvestigation)();
  const {
    data: alertDetails,
    isLoading: isAlertDetailsLoading
  } = (0, _use_fetch_alert.useFetchAlert)({
    investigation
  });
  (0, _react.useEffect)(() => {
    if (!investigation || isAlertDetailsLoading) {
      return;
    }
    observabilityAIAssistant.service.setScreenContext({
      screenDescription: (0, _dedent.default)(`
        The user is looking at the details of an investigation in order to understand the root cause of an issue.
        The investigation details include the title, status, tags, and its time range.

        ${alertDetails ? getAlertDetailScreenContext(alertDetails) : ''}

        Title: ${investigation.title}
        Tags: ${investigation.tags.join(', ')}
        Status: ${investigation.status}
        Start time: ${new Date(investigation.params.timeRange.from).toISOString()}
        End time: ${new Date(investigation.params.timeRange.to).toISOString()}
      `),
      data: [{
        name: 'investigation',
        description: 'The investigation details, including metadata, notes and items.',
        value: investigation
      }, ...(alertDetails ? [{
        name: 'alert',
        description: 'The alert details that triggered the investigation.',
        value: alertDetails
      }] : [])]
    });
  }, [observabilityAIAssistant, investigation, alertDetails, isAlertDetailsLoading]);
}
function getAlertDetailScreenContext(alertDetail) {
  const alertState = alertDetail[_ruleDataUtils.ALERT_STATUS];
  const alertStarted = alertDetail[_ruleDataUtils.ALERT_START];
  return (0, _dedent.default)(`The investigation originates from an ${alertState} alert which started at ${alertStarted}.

  ${alertDetail[_ruleDataUtils.ALERT_REASON] ? `The reason given for the alert is ${alertDetail[_ruleDataUtils.ALERT_REASON]}.` : ''}
  `);
}