"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchInvestigation = useFetchInvestigation;
var _reactQuery = require("@tanstack/react-query");
var _i18n = require("@kbn/i18n");
var _query_key_factory = require("./query_key_factory");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchInvestigation({
  id,
  initialInvestigation
}) {
  const {
    core: {
      http,
      notifications: {
        toasts
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    isInitialLoading,
    isLoading,
    isError,
    isSuccess,
    isRefetching,
    data,
    refetch
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_key_factory.investigationKeys.detail(id),
    queryFn: async ({
      signal
    }) => {
      return await http.get(`/api/observability/investigations/${id}`, {
        version: '2023-10-31',
        signal
      });
    },
    enabled: Boolean(id),
    initialData: initialInvestigation,
    refetchOnWindowFocus: false,
    refetchInterval: 15 * 1000,
    onError: error => {
      toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.investigateApp.useFetchInvestigation.errorTitle', {
          defaultMessage: 'Something went wrong while fetching investigation'
        })
      });
    }
  });
  return {
    data,
    refetch,
    isInitialLoading,
    isLoading,
    isRefetching,
    isSuccess,
    isError
  };
}