"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuggestVisualizationList = SuggestVisualizationList;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const containerClassName = (0, _css.css)`
  min-height: 32px;
`;
const suggestionClassName = (0, _css.css)`
  .euiText {
    text-overflow: ellipsis;
    white-space: nowrap;
    max-width: 140px;
    overflow: hidden;
    text-align: left;
  }
  span {
    justify-content: flex-start;
  }
`;
const iconContainerClassName = (0, _css.css)`
  display: flex;
  align-items: center;
  width: 16px;
`;
function SuggestVisualizationList({
  suggestions,
  loading,
  error,
  onSuggestionClick,
  onSuggestionRollOver,
  onMouseLeave
}) {
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "s",
      alignItems: "center",
      className: containerClassName
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "danger",
      size: "s",
      type: "warning"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "danger"
    }, _i18n.i18n.translate('xpack.investigateApp.suggestVisualizationList.errorLoadingSuggestionsLabel', {
      defaultMessage: 'Error loading suggestions: {message}',
      values: {
        message: error.message
      }
    }))));
  }
  const icon = loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "sortRight"
  });
  let message = '';
  if (loading && !(suggestions !== null && suggestions !== void 0 && suggestions.length)) {
    message = _i18n.i18n.translate('xpack.investigateApp.suggestVisualizationList.loadingSuggestionsLabel', {
      defaultMessage: 'Loading suggestions'
    });
  } else if (!loading && !(suggestions !== null && suggestions !== void 0 && suggestions.length)) {
    message = _i18n.i18n.translate('xpack.investigateApp.suggestVisualizationList.noSuggestionsLabel', {
      defaultMessage: 'No suitable suggestions'
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center",
    className: containerClassName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: iconContainerClassName
  }, icon), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, message ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, message) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s"
  }, suggestions === null || suggestions === void 0 ? void 0 : suggestions.map(suggestion => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: suggestion.id,
    className: suggestionClassName,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "investigateSuggestVisualizationListButton",
    iconType: suggestion.previewIcon,
    iconSize: "s",
    color: "text",
    size: "s",
    onClick: () => {
      onSuggestionClick(suggestion);
    },
    onMouseEnter: () => {
      onSuggestionRollOver(suggestion);
    },
    onMouseLeave: () => {
      onMouseLeave();
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, suggestion.title)))))));
}