"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toCreateInvestigationParams = toCreateInvestigationParams;
exports.toUpdateInvestigationParams = toUpdateInvestigationParams;
var _uuid = require("uuid");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function toCreateInvestigationParams(data) {
  return {
    id: (0, _uuid.v4)(),
    title: data.title,
    params: {
      timeRange: {
        from: new Date(new Date().getTime() - 30 * 60 * 1000).getTime(),
        to: new Date().getTime()
      }
    },
    tags: data.tags,
    origin: {
      type: 'blank'
    },
    externalIncidentUrl: data.externalIncidentUrl && data.externalIncidentUrl.trim().length > 0 ? data.externalIncidentUrl : null
  };
}
function toUpdateInvestigationParams(data) {
  return {
    title: data.title,
    status: data.status,
    tags: data.tags,
    externalIncidentUrl: data.externalIncidentUrl && data.externalIncidentUrl.trim().length > 0 ? data.externalIncidentUrl : null
  };
}