"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusField = StatusField;
exports.statusToColor = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const I18N_STATUS_LABEL = _i18n.i18n.translate('xpack.investigateApp.investigationEditForm.span.statusLabel', {
  defaultMessage: 'Status'
});
const statusToColor = exports.statusToColor = {
  triage: 'warning',
  active: 'danger',
  mitigated: 'success',
  resolved: 'success',
  cancelled: 'default'
};
const options = [{
  label: 'Triage',
  value: 'triage',
  color: statusToColor.triage
}, {
  label: 'Active',
  value: 'active',
  color: statusToColor.active
}, {
  label: 'Mitigated',
  value: 'mitigated',
  color: statusToColor.mitigated
}, {
  label: 'Resolved',
  value: 'resolved',
  color: statusToColor.resolved
}, {
  label: 'Cancelled',
  value: 'cancelled',
  color: statusToColor.cancelled
}];
function StatusField() {
  const {
    control,
    getFieldState
  } = (0, _reactHookForm.useFormContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: I18N_STATUS_LABEL,
    fullWidth: true,
    isInvalid: getFieldState('status').invalid
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: "status",
    rules: {
      required: true
    },
    render: ({
      field,
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({}, field, {
      fullWidth: true,
      isInvalid: fieldState.invalid,
      isClearable: false,
      "aria-label": I18N_STATUS_LABEL,
      placeholder: I18N_STATUS_LABEL,
      options: options,
      selectedOptions: options.filter(option => option.value === field.value),
      onChange: selected => {
        return field.onChange(selected[0].value);
      },
      singleSelection: true
    }))
  }));
}