"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigateTextButton = InvestigateTextButton;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buttonClassName = (0, _css.css)`
  opacity: 0.5;
  &:disabled,
  &:hover {
    opacity: 1;
  }
  &:disabled {
    color: inherit;
  }
`;
const buttonOnlyClassName = (0, _css.css)`
  .euiButtonEmpty__content {
    gap: 0;
  }
`;
function InvestigateTextButton({
  iconType,
  disabled,
  onClick,
  children,
  onMouseEnter,
  onMouseLeave,
  className,
  type,
  color = 'text',
  size = 's',
  iconSize = 's'
}) {
  const props = {
    size,
    iconSize,
    iconType,
    color,
    disabled,
    className: (0, _classnames.default)(buttonClassName, className, {
      [buttonOnlyClassName]: !children
    }),
    onClick,
    onMouseEnter,
    onMouseLeave,
    type,
    children: children ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, children) : undefined
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
    "data-test-subj": "investigateTextButton"
  }, props));
}