"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasDataRoutes = exports.hasDataRoute = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _create_inventory_server_route = require("../create_inventory_server_route");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const hasDataRoute = exports.hasDataRoute = (0, _create_inventory_server_route.createInventoryServerRoute)({
  endpoint: 'GET /internal/inventory/has_data',
  security: {
    authz: {
      requiredPrivileges: ['inventory']
    }
  },
  handler: async ({
    plugins,
    request
  }) => {
    const entityManagerStart = await plugins.entityManager.start();
    const entityManagerClient = await entityManagerStart.getScopedClient({
      request
    });
    const {
      total
    } = await entityManagerClient.v2.countEntities({
      start: (0, _moment.default)().subtract(15, 'm').toISOString(),
      end: (0, _moment.default)().toISOString()
    });
    return {
      hasData: total > 0
    };
  }
});
const hasDataRoutes = exports.hasDataRoutes = {
  ...hasDataRoute
};