"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEntityDefinitionSourceIndexPatternsByType = exports.entityDefinitionsRoutes = void 0;
var _create_inventory_server_route = require("../create_inventory_server_route");
var _extract_entity_index_patterns_from_definitions = require("./extract_entity_index_patterns_from_definitions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEntityDefinitionSourceIndexPatternsByType = exports.getEntityDefinitionSourceIndexPatternsByType = (0, _create_inventory_server_route.createInventoryServerRoute)({
  endpoint: 'GET /internal/inventory/entity/definitions/sources',
  options: {
    tags: ['access:inventory']
  },
  async handler({
    context,
    request,
    plugins
  }) {
    const [_coreContext, entityManagerStart] = await Promise.all([context.core, plugins.entityManager.start()]);
    const entityManagerClient = await entityManagerStart.getScopedClient({
      request
    });
    const entityDefinitionsSource = await entityManagerClient.v2.readSourceDefinitions({});
    return {
      definitionIndexPatterns: (0, _extract_entity_index_patterns_from_definitions.extractEntityIndexPatternsFromDefinitions)(entityDefinitionsSource)
    };
  }
});
const entityDefinitionsRoutes = exports.entityDefinitionsRoutes = {
  ...getEntityDefinitionSourceIndexPatternsByType
};