"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLatestEntitiesAlerts = getLatestEntitiesAlerts;
var _server = require("@kbn/observability-plugin/server");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _get_group_by_terms_agg = require("./get_group_by_terms_agg");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getLatestEntitiesAlerts({
  alertsClient,
  identityFieldsBySource
}) {
  if (Object.keys(identityFieldsBySource).length === 0) {
    return [];
  }
  const filter = {
    size: 0,
    track_total_hits: false,
    query: {
      bool: {
        filter: (0, _server.termQuery)(_ruleDataUtils.ALERT_STATUS, _ruleDataUtils.ALERT_STATUS_ACTIVE)
      }
    }
  };
  const response = await alertsClient.search({
    ...filter,
    aggs: (0, _get_group_by_terms_agg.getGroupByTermsAgg)(identityFieldsBySource)
  });
  const aggregations = response.aggregations;
  const alerts = Object.keys(identityFieldsBySource).map(sourceId => {
    var _entityAggregation$bu;
    const entityAggregation = aggregations === null || aggregations === void 0 ? void 0 : aggregations[sourceId];
    const buckets = (_entityAggregation$bu = entityAggregation.buckets) !== null && _entityAggregation$bu !== void 0 ? _entityAggregation$bu : [];
    return buckets.map(bucket => ({
      alertsCount: bucket.doc_count,
      ...bucket.key
    }));
  }).flat();
  return alerts;
}