"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cancelEsRequestOnAbort = cancelEsRequestOnAbort;
exports.createEntitiesESClient = createEntitiesESClient;
var _entitiesSchema = require("@kbn/entities-schema");
var _unwrap_es_response = require("@kbn/observability-shared-plugin/common/utils/unwrap_es_response");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// import { withApmSpan } from '../../utils/with_apm_span';

const ENTITIES_LATEST_ALIAS = (0, _entitiesSchema.entitiesAliasPattern)({
  type: '*',
  dataset: _entitiesSchema.ENTITY_LATEST
});
function cancelEsRequestOnAbort(promise, request, controller) {
  const subscription = request.events.aborted$.subscribe(() => {
    controller.abort();
  });
  return promise.finally(() => subscription.unsubscribe());
}
function createEntitiesESClient({
  request,
  esClient
}) {
  function search(indexName, operationName, searchRequest) {
    const controller = new AbortController();
    const promise =
    // withApmSpan(operationName, () => {
    cancelEsRequestOnAbort(esClient.search({
      ...searchRequest,
      index: [indexName],
      ignore_unavailable: true
    }, {
      signal: controller.signal,
      meta: true
    }), request, controller);
    // });
    //
    return (0, _unwrap_es_response.unwrapEsResponse)(promise);
  }
  return {
    searchLatest(operationName, searchRequest) {
      return search(ENTITIES_LATEST_ALIAS, operationName, searchRequest);
    }
  };
}