"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDiscoverRedirect = void 0;
var _react = require("react");
var _common = require("@kbn/discover-plugin/common");
var _use_kibana = require("./use_kibana");
var _use_unified_search_context = require("./use_unified_search_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDiscoverRedirect = entity => {
  var _application$capabili2;
  const {
    services: {
      share,
      application,
      entityManager
    }
  } = (0, _use_kibana.useKibana)();
  const {
    discoverDataview
  } = (0, _use_unified_search_context.useUnifiedSearchContext)();
  const {
    dataView
  } = discoverDataview;
  const discoverLocator = share.url.locators.get(_common.DISCOVER_APP_LOCATOR);
  const getDiscoverEntitiesRedirectUrl = (0, _react.useCallback)(() => {
    var _application$capabili, _dataView$toMinimalSp;
    const entityKqlFilter = entity ? entityManager.entityClient.asKqlFilter({
      entity
    }) : '';
    return (_application$capabili = application.capabilities.discover) !== null && _application$capabili !== void 0 && _application$capabili.show ? discoverLocator === null || discoverLocator === void 0 ? void 0 : discoverLocator.getRedirectUrl({
      dataViewSpec: dataView === null || dataView === void 0 ? void 0 : (_dataView$toMinimalSp = dataView.toMinimalSpec) === null || _dataView$toMinimalSp === void 0 ? void 0 : _dataView$toMinimalSp.call(dataView),
      query: {
        query: entityKqlFilter,
        language: 'kuery'
      }
    }) : undefined;
  }, [(_application$capabili2 = application.capabilities.discover) === null || _application$capabili2 === void 0 ? void 0 : _application$capabili2.show, dataView, discoverLocator, entity, entityManager.entityClient]);
  return {
    getDiscoverEntitiesRedirectUrl
  };
};
exports.useDiscoverRedirect = useDiscoverRedirect;