"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDetailViewRedirect = void 0;
var _common = require("@kbn/observability-shared-plugin/common");
var _react = require("react");
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _check_entity_type = require("../../common/utils/check_entity_type");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KUBERNETES_DASHBOARDS_IDS = {
  [_common.BUILT_IN_ENTITY_TYPES.KUBERNETES_V2.CLUSTER.ecs]: 'kubernetes-f4dc26db-1b53-4ea2-a78b-1bfab8ea267c',
  [_common.BUILT_IN_ENTITY_TYPES.KUBERNETES_V2.CLUSTER.semconv]: 'kubernetes_otel-cluster-overview',
  [_common.BUILT_IN_ENTITY_TYPES.KUBERNETES_V2.CRON_JOB.ecs]: 'kubernetes-0a672d50-bcb1-11ec-b64f-7dd6e8e82013',
  [_common.BUILT_IN_ENTITY_TYPES.KUBERNETES_V2.DAEMON_SET.ecs]: 'kubernetes-85879010-bcb1-11ec-b64f-7dd6e8e82013',
  [_common.BUILT_IN_ENTITY_TYPES.KUBERNETES_V2.DEPLOYMENT.ecs]: 'kubernetes-5be46210-bcb1-11ec-b64f-7dd6e8e82013',
  [_common.BUILT_IN_ENTITY_TYPES.KUBERNETES_V2.JOB.ecs]: 'kubernetes-9bf990a0-bcb1-11ec-b64f-7dd6e8e82013',
  [_common.BUILT_IN_ENTITY_TYPES.KUBERNETES_V2.NODE.ecs]: 'kubernetes-b945b7b0-bcb1-11ec-b64f-7dd6e8e82013',
  [_common.BUILT_IN_ENTITY_TYPES.KUBERNETES_V2.POD.ecs]: 'kubernetes-3d4d9290-bcb1-11ec-b64f-7dd6e8e82013',
  [_common.BUILT_IN_ENTITY_TYPES.KUBERNETES_V2.SERVICE]: 'kubernetes-ff1b3850-bcb1-11ec-b64f-7dd6e8e82013',
  [_common.BUILT_IN_ENTITY_TYPES.KUBERNETES_V2.STATEFUL_SET.ecs]: 'kubernetes-21694370-bcb2-11ec-b64f-7dd6e8e82013'
};
const useDetailViewRedirect = () => {
  const {
    services: {
      share,
      entityManager
    }
  } = (0, _use_kibana.useKibana)();
  const locators = share.url.locators;
  const assetDetailsLocator = locators.get(_common.ASSET_DETAILS_LOCATOR_ID);
  const dashboardLocator = locators.get(_deeplinksAnalytics.DASHBOARD_APP_LOCATOR);
  const serviceOverviewLocator = locators.get(_common.SERVICE_OVERVIEW_LOCATOR_ID);
  const getDetailViewRedirectUrl = (0, _react.useCallback)(entity => {
    const identityFieldsValue = entityManager.entityClient.getIdentityFieldsValue({
      entity
    });
    const identityFields = Object.keys(identityFieldsValue || {});
    if ((0, _check_entity_type.isBuiltinEntityOfType)(_common.BUILT_IN_ENTITY_TYPES.HOST_V2, entity) || (0, _check_entity_type.isBuiltinEntityOfType)(_common.BUILT_IN_ENTITY_TYPES.CONTAINER_V2, entity)) {
      return assetDetailsLocator === null || assetDetailsLocator === void 0 ? void 0 : assetDetailsLocator.getRedirectUrl({
        assetId: identityFieldsValue[identityFields[0]],
        assetType: (0, _check_entity_type.isBuiltinEntityOfType)(_common.BUILT_IN_ENTITY_TYPES.HOST_V2, entity) ? 'host' : 'container'
      });
    }
    if ((0, _check_entity_type.isBuiltinEntityOfType)(_common.BUILT_IN_ENTITY_TYPES.SERVICE_V2, entity)) {
      return serviceOverviewLocator === null || serviceOverviewLocator === void 0 ? void 0 : serviceOverviewLocator.getRedirectUrl({
        serviceName: identityFieldsValue[identityFields[0]]
      });
    }
    return undefined;
  }, [assetDetailsLocator, entityManager.entityClient, serviceOverviewLocator]);
  const getDashboardRedirectUrl = (0, _react.useCallback)(entity => {
    const {
      entityType: type
    } = entity;
    const dashboardId = KUBERNETES_DASHBOARDS_IDS[type];
    return dashboardId ? dashboardLocator === null || dashboardLocator === void 0 ? void 0 : dashboardLocator.getRedirectUrl({
      dashboardId,
      query: {
        language: 'kuery',
        query: entityManager.entityClient.asKqlFilter({
          entity
        })
      }
    }) : undefined;
  }, [dashboardLocator, entityManager.entityClient]);
  const getEntityRedirectUrl = (0, _react.useCallback)(entity => {
    var _getDetailViewRedirec;
    return (_getDetailViewRedirec = getDetailViewRedirectUrl(entity)) !== null && _getDetailViewRedirec !== void 0 ? _getDetailViewRedirec : getDashboardRedirectUrl(entity);
  }, [getDashboardRedirectUrl, getDetailViewRedirectUrl]);
  return {
    getEntityRedirectUrl
  };
};
exports.useDetailViewRedirect = useDetailViewRedirect;