"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityIcon = EntityIcon;
var _react = _interopRequireDefault(require("react"));
var _customIcons = require("@kbn/custom-icons");
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _lodash = require("lodash");
var _common = require("@kbn/observability-shared-plugin/common");
var _check_entity_type = require("../../../common/utils/check_entity_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EntityIcon({
  entity
}) {
  const defaultIconSize = _uiTheme.euiThemeVars.euiSizeL;
  if ((0, _check_entity_type.isBuiltinEntityOfType)(_common.BUILT_IN_ENTITY_TYPES.HOST_V2, entity) || (0, _check_entity_type.isBuiltinEntityOfType)(_common.BUILT_IN_ENTITY_TYPES.CONTAINER_V2, entity)) {
    const cloudProvider = (0, _lodash.castArray)(entity['cloud.provider'])[0];
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      style: {
        width: defaultIconSize,
        height: defaultIconSize
      },
      alignItems: "center",
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_customIcons.CloudProviderIcon, {
      cloudProvider: cloudProvider,
      size: "m",
      title: cloudProvider,
      role: "presentation"
    })));
  }
  if ((0, _check_entity_type.isBuiltinEntityOfType)(_common.BUILT_IN_ENTITY_TYPES.SERVICE_V2, entity)) {
    return /*#__PURE__*/_react.default.createElement(_customIcons.AgentIcon, {
      agentName: (0, _lodash.castArray)(entity['agent.name'])[0],
      role: "presentation"
    });
  }
  if (entity.entityType.startsWith('k8s')) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "logoKubernetes",
      size: "l"
    });
  }

  // Return an empty EuiIcon instead of null to maintain UI alignment across all EntityIcon usages
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "",
    size: "l"
  });
}