"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityGroupAccordion = EntityGroupAccordion;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireWildcard(require("react"));
var _entity_count_badge = require("./entity_count_badge");
var _grouped_entities_grid = require("./grouped_entities_grid");
var _use_unified_search_context = require("../../hooks/use_unified_search_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ENTITIES_COUNT_BADGE = _i18n.i18n.translate('xpack.inventory.inventoryGroupPanel.entitiesBadgeLabel', {
  defaultMessage: 'Entities'
});
function EntityGroupAccordion({
  groupValue,
  groupLabel,
  groupCount,
  isLoading
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [open, setOpen] = (0, _react2.useState)(false);
  const {
    setSingleEntityType
  } = (0, _use_unified_search_context.useUnifiedSearchContext)();
  const onToggle = (0, _react2.useCallback)(() => {
    if (!open) setSingleEntityType(groupValue);
    setOpen(opened => !opened);
  }, [groupValue, open, setSingleEntityType]);
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    css: (0, _react.css)`
          padding: ${euiTheme.size.xs} ${euiTheme.size.base};
        `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiAccordion, {
    "data-test-subj": `inventoryGroup_entityType_${groupValue}`,
    id: `inventoryGroup-entityType-${groupValue}`,
    buttonContent: /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react2.default.createElement("h4", {
      "data-test-subj": `inventoryGroupTitle_entityType_${groupValue}`
    }, groupLabel)),
    buttonElement: "div",
    extraAction: /*#__PURE__*/_react2.default.createElement(_entity_count_badge.EntityCountBadge, {
      "data-test-subj": `entityCountBadge_entityType_${groupValue}`,
      name: ENTITIES_COUNT_BADGE,
      value: groupCount
    }),
    buttonProps: {
      paddingSize: 'm'
    },
    paddingSize: "none",
    onToggle: onToggle,
    isLoading: isLoading
  })), open && /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    css: (0, _react.css)`
            margin: 0 ${euiTheme.size.s};
            border-top: none;
            border-radius: 0 0 ${euiTheme.border.radius.medium} ${euiTheme.border.radius.medium};
          `,
    hasBorder: true,
    hasShadow: false,
    paddingSize: "m"
  }, /*#__PURE__*/_react2.default.createElement(_grouped_entities_grid.GroupedEntitiesGrid, {
    groupValue: groupValue
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }));
}