"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupedEntitiesGrid = GroupedEntitiesGrid;
var _react = _interopRequireDefault(require("react"));
var _useEffectOnce = _interopRequireDefault(require("react-use/lib/useEffectOnce"));
var _rt_types = require("../../../common/rt_types");
var _use_inventory_abortable_async = require("../../hooks/use_inventory_abortable_async");
var _use_inventory_decoded_query_params = require("../../hooks/use_inventory_decoded_query_params");
var _use_inventory_params = require("../../hooks/use_inventory_params");
var _use_inventory_router = require("../../hooks/use_inventory_router");
var _use_kibana = require("../../hooks/use_kibana");
var _use_unified_search_context = require("../../hooks/use_unified_search_context");
var _entities_grid = require("../entities_grid");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function GroupedEntitiesGrid({
  groupValue
}) {
  var _pagination$groupValu;
  const {
    query
  } = (0, _use_inventory_params.useInventoryParams)('/');
  const {
    sortField,
    sortDirection,
    kuery
  } = query;
  const {
    pagination,
    entityTypes
  } = (0, _use_inventory_decoded_query_params.useInventoryDecodedQueryParams)();
  const inventoryRoute = (0, _use_inventory_router.useInventoryRouter)();
  const pageIndex = (_pagination$groupValu = pagination === null || pagination === void 0 ? void 0 : pagination[groupValue]) !== null && _pagination$groupValu !== void 0 ? _pagination$groupValu : 0;
  const {
    refreshSubject$
  } = (0, _use_unified_search_context.useUnifiedSearchContext)();
  const {
    services: {
      inventoryAPIClient
    }
  } = (0, _use_kibana.useKibana)();
  const {
    value = {
      entities: []
    },
    loading,
    refresh
  } = (0, _use_inventory_abortable_async.useInventoryAbortableAsync)(({
    signal
  }) => {
    return inventoryAPIClient.fetch('GET /internal/inventory/entities', {
      params: {
        query: {
          sortDirection,
          sortField,
          kuery,
          entityType: groupValue
        }
      },
      signal
    });
  }, [groupValue, inventoryAPIClient, sortDirection, sortField, kuery]);
  (0, _useEffectOnce.default)(() => {
    const refreshSubscription = refreshSubject$.subscribe(refresh);
    return () => refreshSubscription.unsubscribe();
  });
  function handlePageChange(nextPage) {
    inventoryRoute.push('/', {
      path: {},
      query: {
        ...query,
        pagination: _rt_types.entityPaginationRt.encode({
          ...pagination,
          [groupValue]: nextPage
        })
      }
    });
  }
  function handleSortChange(sorting) {
    inventoryRoute.push('/', {
      path: {},
      query: {
        ...query,
        sortField: sorting.id,
        sortDirection: sorting.direction
      }
    });
  }
  function handleEntityTypeFilter(entityType, checkOption) {
    inventoryRoute.push('/', {
      path: {},
      query: {
        ...query,
        entityTypes: _rt_types.entityTypesRt.encode({
          ...entityTypes,
          [entityType]: checkOption
        })
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_entities_grid.EntitiesGrid, {
    entities: value.entities,
    loading: loading,
    sortDirection: sortDirection,
    sortField: sortField,
    onChangePage: handlePageChange,
    onChangeSort: handleSortChange,
    pageIndex: pageIndex,
    onFilterByType: handleEntityTypeFilter
  });
}