"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntitiesSummary = EntitiesSummary;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EntitiesSummary({
  totalEntities,
  totalGroups
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isGrouped = totalGroups !== undefined;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    css: (0, _react2.css)`
        font-weight: ${euiTheme.font.weight.semiBold};
      `
  }, totalEntities !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "inventorySummaryEntitiesTotal",
    css: (0, _react2.css)`
              border-right: ${isGrouped ? euiTheme.border.thin : 'none'};
              margin-right: ${euiTheme.size.base};
              padding-right: ${euiTheme.size.base};
            `
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.inventory.groupedInventoryPage.entitiesTotalLabel",
    defaultMessage: "{total} Entities",
    values: {
      total: totalEntities
    }
  }))), isGrouped ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "inventorySummaryGroupsTotal"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.inventory.groupedInventoryPage.groupsTotalLabel",
    defaultMessage: "{total} Groups",
    values: {
      total: totalGroups
    }
  }))) : null);
}