"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColumns = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const alertsLabel = _i18n.i18n.translate('xpack.inventory.entitiesGrid.euiDataGrid.alertsLabel', {
  defaultMessage: 'Alerts'
});
const alertsTooltip = _i18n.i18n.translate('xpack.inventory.entitiesGrid.euiDataGrid.alertsTooltip', {
  defaultMessage: 'The count of the active alerts'
});
const entityNameLabel = _i18n.i18n.translate('xpack.inventory.entitiesGrid.euiDataGrid.entityNameLabel', {
  defaultMessage: 'Entity name'
});
const entityNameTooltip = _i18n.i18n.translate('xpack.inventory.entitiesGrid.euiDataGrid.entityNameTooltip', {
  defaultMessage: 'Name of the entity (entity.displayName)'
});
const entityTypeLabel = _i18n.i18n.translate('xpack.inventory.entitiesGrid.euiDataGrid.typeLabel', {
  defaultMessage: 'Type'
});
const entityTypeTooltip = _i18n.i18n.translate('xpack.inventory.entitiesGrid.euiDataGrid.typeTooltip', {
  defaultMessage: 'Type of entity (entity.type)'
});
const entityLastSeenLabel = _i18n.i18n.translate('xpack.inventory.entitiesGrid.euiDataGrid.lastSeenLabel', {
  defaultMessage: 'Last seen'
});
const entityLastSeenTooltip = _i18n.i18n.translate('xpack.inventory.entitiesGrid.euiDataGrid.lastSeenTooltip', {
  defaultMessage: 'Timestamp of last received data for entity (entity.lastSeenTimestamp)'
});
const entityActionsLabel = _i18n.i18n.translate('xpack.inventory.entitiesGrid.euiDataGrid.actionsLabel', {
  defaultMessage: 'Actions'
});
const CustomHeaderCell = ({
  title,
  tooltipContent
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", null, title), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: tooltipContent
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
  "data-test-subj": "inventoryCustomHeaderCellButton",
  iconType: "questionInCircle",
  "aria-label": tooltipContent,
  color: "primary"
})));
const getColumns = ({
  showAlertsColumn,
  showActions
}) => {
  return [...(showAlertsColumn ? [{
    id: 'alertsCount',
    displayAsText: alertsLabel,
    isSortable: true,
    display: /*#__PURE__*/_react.default.createElement(CustomHeaderCell, {
      title: alertsLabel,
      tooltipContent: alertsTooltip
    }),
    initialWidth: 100,
    schema: 'numeric'
  }] : []), {
    id: 'entityDisplayName',
    // keep it for accessibility purposes
    displayAsText: entityNameLabel,
    display: /*#__PURE__*/_react.default.createElement(CustomHeaderCell, {
      title: entityNameLabel,
      tooltipContent: entityNameTooltip
    }),
    isSortable: true
  }, {
    id: 'entityType',
    // keep it for accessibility purposes
    displayAsText: entityTypeLabel,
    display: /*#__PURE__*/_react.default.createElement(CustomHeaderCell, {
      title: entityTypeLabel,
      tooltipContent: entityTypeTooltip
    }),
    isSortable: true
  }, {
    id: 'entityLastSeenTimestamp',
    // keep it for accessibility purposes
    displayAsText: entityLastSeenLabel,
    display: /*#__PURE__*/_react.default.createElement(CustomHeaderCell, {
      title: entityLastSeenLabel,
      tooltipContent: entityLastSeenTooltip
    }),
    defaultSortDirection: 'desc',
    isSortable: true,
    schema: 'datetime'
  }, ...(showActions ? [{
    id: 'actions',
    // keep it for accessibility purposes
    displayAsText: entityActionsLabel,
    display: /*#__PURE__*/_react.default.createElement("span", null, entityActionsLabel),
    initialWidth: 100
  }] : [])];
};
exports.getColumns = getColumns;