"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyState = EmptyState;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _sharedSvg = require("@kbn/shared-svg");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _buttons = require("../shared/add_data_buttons/buttons");
var _use_kibana = require("../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EmptyState() {
  const {
    services
  } = (0, _use_kibana.useKibana)();
  const [isDismissed, setDismissed] = (0, _useLocalStorage.default)('inventory.emptyStateDismissed', false);
  function reportButtonClick(journey) {
    services.telemetry.reportInventoryAddData({
      view: 'empty_state',
      journey
    });
  }
  const {
    colorMode
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, !isDismissed && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    css: {
      textAlign: 'left'
    },
    onDismiss: () => setDismissed(true),
    title: _i18n.i18n.translate('xpack.inventory.noEntitiesEmptyState.callout.title', {
      defaultMessage: 'Trying for the first time?'
    })
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.inventory.noEntitiesEmptyState.description', {
    defaultMessage: 'It can take a couple of minutes for your entities to show. Try refreshing in a minute or two.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    external: true,
    target: "_blank",
    "data-test-subj": "inventoryEmptyStateLink",
    href: "https://ela.st/inventory-first-time"
  }, _i18n.i18n.translate('xpack.inventory.noEntitiesEmptyState.learnMore.link', {
    defaultMessage: 'Learn more'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    hasShadow: false,
    hasBorder: false,
    id: "inventoryEmptyState",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "fullWidth",
      src: colorMode === _eui.COLOR_MODES_STANDARD.dark ? _sharedSvg.dashboardsDark : _sharedSvg.dashboardsLight,
      alt: ""
    }),
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.inventory.noEntitiesEmptyState.title', {
      defaultMessage: 'No entities available'
    })),
    layout: 'horizontal',
    color: "plain",
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.inventory.noEntitiesEmptyState.body.description', {
      defaultMessage: 'See all of your observed entities in one place by collecting some data.'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      textAlign: "left"
    }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "default"
    }, _i18n.i18n.translate('xpack.inventory.noEntitiesEmptyState.actions.title', {
      defaultMessage: 'Start observing your entities:'
    }))))),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      wrap: true,
      gutterSize: "xl",
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_buttons.AddData, {
      onClick: () => {
        reportButtonClick('add_data');
      }
    }), /*#__PURE__*/_react.default.createElement(_buttons.AssociateServiceLogs, {
      onClick: () => {
        reportButtonClick('associate_existing_service_logs');
      }
    })))
  })));
}