"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShareLink = ShareLink;
var _react = _interopRequireWildcard(require("react"));
var _copyToClipboard = _interopRequireDefault(require("copy-to-clipboard"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_kibana = require("../../../hooks/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SHARE_BUTTON_LABEL = _i18n.i18n.translate('xpack.inventory.shareLink.shareButtonLabel', {
  defaultMessage: 'Share'
});
const SHARE_TOAST_SUCCESS_LABEL = _i18n.i18n.translate('xpack.inventory.shareLink.shareToastSuccessLabel', {
  defaultMessage: 'Short URL copied to clipboard!'
});
const SHARE_TOAST_FAILURE_LABEL = _i18n.i18n.translate('xpack.inventory.shareLink.shareToastFailureLabel', {
  defaultMessage: 'Short URL unable to be copied.'
});
function useShortUrlService() {
  const {
    services: {
      share,
      notifications
    }
  } = (0, _use_kibana.useKibana)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const copyShortUrl = (0, _react.useCallback)(async () => {
    setIsLoading(true);
    try {
      const shortUrls = share.url.shortUrls.get(null);
      const {
        url
      } = await shortUrls.createFromLongUrl(window.location.toString());
      setIsLoading(false);
      if ((0, _copyToClipboard.default)(url)) {
        notifications.toasts.addSuccess({
          title: SHARE_TOAST_SUCCESS_LABEL,
          iconType: 'copyClipboard'
        });
      } else {
        throw new Error('Clipboard copy error');
      }
    } catch (e) {
      const err = e;
      notifications.toasts.addDanger({
        title: SHARE_TOAST_FAILURE_LABEL,
        iconType: 'error',
        text: err.message
      });
    }
  }, [share, notifications.toasts]);
  return {
    isLoading,
    copyShortUrl
  };
}
function ShareLink() {
  const {
    isLoading,
    copyShortUrl
  } = useShortUrlService();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "inventoryShareLinkButton",
    onClick: copyShortUrl,
    iconType: "share",
    isLoading: isLoading
  }, SHARE_BUTTON_LABEL);
}