"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsBadge = AlertsBadge;
var _react = _interopRequireDefault(require("react"));
var _rison = _interopRequireDefault(require("@kbn/rison"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_kibana = require("../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AlertsBadge({
  entity
}) {
  const {
    services: {
      http: {
        basePath
      },
      entityManager
    }
  } = (0, _use_kibana.useKibana)();
  const activeAlertsHref = basePath.prepend(`/app/observability/alerts?_a=${_rison.default.encode({
    kuery: entityManager.entityClient.asKqlFilter({
      entity
    }),
    status: 'active'
  })}`);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    content: _i18n.i18n.translate('xpack.inventory.home.serviceAlertsTable.tooltip.activeAlertsExplanation', {
      defaultMessage: 'Active alerts'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    "data-test-subj": "inventoryAlertsBadgeLink",
    iconType: "warning",
    color: "danger",
    iconSide: "left",
    href: activeAlertsHref
  }, entity.alertsCount));
}