"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHasMetricsData = getHasMetricsData;
var _server = require("@kbn/observability-plugin/server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getHasMetricsData({
  infraMetricsClient,
  field,
  entityId
}) {
  const results = await infraMetricsClient.search({
    allow_no_indices: true,
    ignore_unavailable: true,
    body: {
      track_total_hits: true,
      terminate_after: 1,
      size: 0,
      query: {
        bool: {
          filter: (0, _server.termQuery)(field, entityId)
        }
      }
    }
  });
  return results.hits.total.value !== 0;
}