"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataStreamTypes = getDataStreamTypes;
var _common = require("@kbn/metrics-data-access-plugin/common");
var _common2 = require("@kbn/observability-shared-plugin/common");
var _lodash = require("lodash");
var _get_has_metrics_data = require("./get_has_metrics_data");
var _get_latest_entity = require("./get_latest_entity");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getDataStreamTypes({
  entityCentricExperienceEnabled,
  entityId,
  entityManagerClient,
  entityType,
  entityFilterType,
  infraMetricsClient,
  from,
  to,
  logger
}) {
  const hasMetricsData = await (0, _get_has_metrics_data.getHasMetricsData)({
    infraMetricsClient,
    entityId,
    field: (0, _common.findInventoryFields)(entityFilterType).id
  });
  const sourceDataStreams = new Set(hasMetricsData ? [_common2.EntityDataStreamType.METRICS] : []);
  if (!entityCentricExperienceEnabled) {
    return Array.from(sourceDataStreams);
  }
  const latestEntity = await (0, _get_latest_entity.getLatestEntity)({
    entityId,
    entityType,
    entityManagerClient,
    logger,
    from,
    to
  });
  if (latestEntity) {
    (0, _lodash.castArray)(latestEntity.sourceDataStreamType).forEach(item => {
      if ([_common2.EntityDataStreamType.LOGS, _common2.EntityDataStreamType.METRICS].includes(item)) {
        sourceDataStreams.add(item);
      }
    });
  }
  return Array.from(sourceDataStreams).filter(Boolean);
}