"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NodesOverview = void 0;
var _i18n = require("@kbn/i18n");
var _ebtTools = require("@kbn/ebt-tools");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _empty_states = require("../../../../components/empty_states");
var _loading = require("../../../../components/loading");
var _map = require("./waffle/map");
var _table_view = require("./table_view");
var _calculate_bounds_from_nodes = require("../lib/calculate_bounds_from_nodes");
var _legend = require("./waffle/legend");
var _use_asset_details_flyout_url_state = require("../hooks/use_asset_details_flyout_url_state");
var _asset_details_flyout = require("./waffle/asset_details_flyout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NodesOverview = ({
  autoBounds,
  boundsOverride,
  loading,
  nodes,
  nodeType,
  reload,
  view,
  currentTime,
  options,
  formatter,
  onDrilldown,
  bottomMargin,
  showLoading,
  refreshInterval,
  isAutoReloading
}) => {
  const currentBreakpoint = (0, _eui.useCurrentEuiBreakpoint)();
  const [{
    detailsItemId,
    assetType
  }, setFlyoutUrlState] = (0, _use_asset_details_flyout_url_state.useAssetDetailsFlyoutState)();
  const {
    onPageReady
  } = (0, _ebtTools.usePerformanceContext)();
  const nodeName = (0, _react.useMemo)(() => {
    var _nodes$find;
    return (_nodes$find = nodes.find(node => node.path[0].value === detailsItemId)) === null || _nodes$find === void 0 ? void 0 : _nodes$find.name;
  }, [detailsItemId, nodes]);
  const closeFlyout = (0, _react.useCallback)(() => setFlyoutUrlState({
    detailsItemId: null,
    assetType: null
  }), [setFlyoutUrlState]);
  const handleDrilldown = (0, _react.useCallback)(filter => {
    onDrilldown({
      kind: 'kuery',
      expression: filter
    });
    return;
  }, [onDrilldown]);
  const noData = !loading && nodes && nodes.length === 0;
  if (loading && showLoading) {
    // Don't show loading screen when we're auto-reloading
    return /*#__PURE__*/_react.default.createElement(_loading.InfraLoadingPanel, {
      height: "100%",
      width: "100%",
      text: _i18n.i18n.translate('xpack.infra.waffle.loadingDataText', {
        defaultMessage: 'Loading data'
      })
    });
  } else if (noData) {
    return /*#__PURE__*/_react.default.createElement(_empty_states.NoData, {
      titleText: _i18n.i18n.translate('xpack.infra.waffle.noDataTitle', {
        defaultMessage: 'There is no data to display.'
      }),
      bodyText: _i18n.i18n.translate('xpack.infra.waffle.noDataDescription', {
        defaultMessage: 'Try adjusting your time or filter.'
      }),
      refetchText: _i18n.i18n.translate('xpack.infra.waffle.checkNewDataButtonLabel', {
        defaultMessage: 'Check for new data'
      }),
      onRefetch: () => {
        reload();
      },
      testString: "noMetricsDataPrompt"
    });
  }
  const dataBounds = (0, _calculate_bounds_from_nodes.calculateBoundsFromNodes)(nodes);
  const bounds = autoBounds ? dataBounds : boundsOverride;
  const isStatic = ['xs', 's'].includes(currentBreakpoint);
  if (!loading) {
    onPageReady();
  }
  if (view === 'table') {
    return /*#__PURE__*/_react.default.createElement(TableContainer, null, /*#__PURE__*/_react.default.createElement(_table_view.TableView, {
      nodeType: nodeType,
      nodes: nodes,
      options: options,
      formatter: formatter,
      currentTime: currentTime,
      onFilter: handleDrilldown
    }), nodeType === assetType && detailsItemId && /*#__PURE__*/_react.default.createElement(_asset_details_flyout.AssetDetailsFlyout, {
      assetId: detailsItemId,
      assetName: nodeName,
      assetType: nodeType,
      closeFlyout: closeFlyout,
      currentTime: currentTime,
      isAutoReloading: isAutoReloading,
      options: options,
      refreshInterval: refreshInterval
    }));
  }
  return /*#__PURE__*/_react.default.createElement(MapContainer, {
    positionStatic: isStatic
  }, /*#__PURE__*/_react.default.createElement(_map.Map, {
    nodeType: nodeType,
    nodes: nodes,
    detailsItemId: detailsItemId,
    options: options,
    formatter: formatter,
    currentTime: currentTime,
    onFilter: handleDrilldown,
    bounds: bounds,
    bottomMargin: bottomMargin,
    staticHeight: isStatic
  }), nodeType === assetType && detailsItemId && /*#__PURE__*/_react.default.createElement(_asset_details_flyout.AssetDetailsFlyout, {
    assetId: detailsItemId,
    assetName: nodeName,
    assetType: nodeType,
    closeFlyout: closeFlyout,
    currentTime: currentTime,
    isAutoReloading: isAutoReloading,
    options: options,
    refreshInterval: refreshInterval
  }), /*#__PURE__*/_react.default.createElement(_legend.Legend, {
    formatter: formatter,
    bounds: bounds,
    dataBounds: dataBounds,
    legend: options.legend
  }));
};
exports.NodesOverview = NodesOverview;
const TableContainer = _common.euiStyled.div`
  padding: ${props => props.theme.eui.euiSizeL};
`;
const MapContainer = _common.euiStyled.div`
  position: ${props => props.positionStatic ? 'static' : 'absolute'};
  display: flex;
  top: 0;
  right: 0;
  bottom: 0;
  left: 0;
`;