"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InfrastructurePage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _common = require("@kbn/observability-plugin/common");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _sharedUxErrorBoundary = require("@kbn/shared-ux-error-boundary");
var _help_center_content = require("../../components/help_center_content");
var _use_readonly_badge = require("../../hooks/use_readonly_badge");
var _settings = require("./settings");
var _metrics_alert_dropdown = require("../../alerting/common/components/metrics_alert_dropdown");
var _use_alert_prefill = require("../../alerting/use_alert_prefill");
var _infra_ml_capabilities = require("../../containers/ml/infra_ml_capabilities");
var _anomaly_detection_flyout = require("../../components/ml/anomaly_detection/anomaly_detection_flyout");
var _header_action_menu_provider = require("../../containers/header_action_menu_provider");
var _ = require("../404");
var _react_query_provider = require("../../containers/react_query_provider");
var _plugin_config_context = require("../../containers/plugin_config_context");
var _redirect_with_query_params = require("../../utils/redirect_with_query_params");
var _use_reload_request_time = require("../../hooks/use_reload_request_time");
var _no_data_config = require("../../components/shared/templates/no_data_config");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ADD_DATA_LABEL = _i18n.i18n.translate('xpack.infra.metricsHeaderAddDataButtonLabel', {
  defaultMessage: 'Add data'
});
const MetricsExplorerPage = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./metrics_explorer'))).then(mod => ({
  default: mod.MetricsExplorerPage
})));
const SnapshotPage = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./inventory_view'))).then(mod => ({
  default: mod.SnapshotPage
})));
const NodeDetail = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./metric_detail'))).then(mod => ({
  default: mod.NodeDetail
})));
const HostsPage = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./hosts'))).then(mod => ({
  default: mod.HostsPage
})));
const InfrastructurePage = () => {
  var _uiCapabilities$infra;
  const config = (0, _plugin_config_context.usePluginConfig)();
  const {
    application
  } = (0, _public.useKibana)().services;
  const {
    setHeaderActionMenu,
    theme$
  } = (0, _react.useContext)(_header_action_menu_provider.HeaderActionMenuContext);
  const isHostsViewEnabled = (0, _public.useUiSetting)(_common.enableInfrastructureHostsView);
  const uiCapabilities = application === null || application === void 0 ? void 0 : application.capabilities;
  const settingsTabTitle = _i18n.i18n.translate('xpack.infra.metrics.settingsTabTitle', {
    defaultMessage: 'Settings'
  });
  (0, _use_readonly_badge.useReadOnlyBadge)(!(uiCapabilities !== null && uiCapabilities !== void 0 && (_uiCapabilities$infra = uiCapabilities.infrastructure) !== null && _uiCapabilities$infra !== void 0 && _uiCapabilities$infra.save));
  const settingsLinkProps = (0, _public2.useLinkProps)({
    app: 'metrics',
    pathname: 'settings'
  });
  return /*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.KibanaErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_react_query_provider.ReactQueryProvider, null, /*#__PURE__*/_react.default.createElement(_use_alert_prefill.AlertPrefillProvider, null, /*#__PURE__*/_react.default.createElement(_use_reload_request_time.ReloadRequestTimeProvider, null, /*#__PURE__*/_react.default.createElement(_infra_ml_capabilities.InfraMLCapabilitiesProvider, null, /*#__PURE__*/_react.default.createElement(_help_center_content.HelpCenterContent, {
    feedbackLink: "https://discuss.elastic.co/c/metrics",
    appName: _i18n.i18n.translate('xpack.infra.header.infrastructureHelpAppName', {
      defaultMessage: 'Metrics'
    })
  }), setHeaderActionMenu && theme$ && /*#__PURE__*/_react.default.createElement(_public2.HeaderMenuPortal, {
    setHeaderActionMenu: setHeaderActionMenu,
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLinks, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, (0, _extends2.default)({
    color: 'text'
  }, settingsLinkProps), settingsTabTitle), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(HeaderLinkAnomalyFlyoutRoute, {
    path: "/inventory"
  }), /*#__PURE__*/_react.default.createElement(HeaderLinkAnomalyFlyoutRoute, {
    path: "/hosts"
  }), /*#__PURE__*/_react.default.createElement(HeaderLinkAnomalyFlyoutRoute, {
    path: "/detail/host/:node"
  })), config.featureFlags.alertsAndRulesDropdownEnabled && /*#__PURE__*/_react.default.createElement(_metrics_alert_dropdown.MetricsAlertDropdown, null), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(HeaderLinkAddDataRoute, {
    path: "/hosts",
    onboardingFlow: _no_data_config.OnboardingFlow.Hosts,
    exact: true
  }), /*#__PURE__*/_react.default.createElement(HeaderLinkAddDataRoute, {
    path: "/detail/host/:node",
    onboardingFlow: _no_data_config.OnboardingFlow.Hosts,
    exact: true
  }), /*#__PURE__*/_react.default.createElement(HeaderLinkAddDataRoute, {
    path: "/",
    onboardingFlow: _no_data_config.OnboardingFlow.Infra
  })))))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    enableExecutionContextTracking: true
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/inventory",
    component: SnapshotPage
  }), config.featureFlags.metricsExplorerEnabled && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/explorer",
    component: MetricsExplorerPage
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/detail/:type/:node",
    component: NodeDetail
  }), isHostsViewEnabled ? /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/hosts",
    component: HostsPage
  }) : null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/settings",
    component: _settings.MetricsSettingsPage
  }), /*#__PURE__*/_react.default.createElement(_redirect_with_query_params.RedirectWithQueryParams, {
    from: "/snapshot",
    exact: true,
    to: "/inventory"
  }), /*#__PURE__*/_react.default.createElement(_redirect_with_query_params.RedirectWithQueryParams, {
    from: "/metrics-explorer",
    exact: true,
    to: "/explorer"
  }), /*#__PURE__*/_react.default.createElement(_redirect_with_query_params.RedirectWithQueryParams, {
    from: "/",
    exact: true,
    to: "/inventory"
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    render: () => /*#__PURE__*/_react.default.createElement(_.NotFoundPage, {
      title: _i18n.i18n.translate('xpack.infra.header.infrastructureLabel', {
        defaultMessage: 'Infrastructure'
      })
    })
  })))))));
};
exports.InfrastructurePage = InfrastructurePage;
const HeaderLinkAnomalyFlyoutRoute = ({
  path
}) => {
  const isInventory = path !== '/inventory';
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: path,
    render: () => /*#__PURE__*/_react.default.createElement(_anomaly_detection_flyout.AnomalyDetectionFlyout, {
      hideJobType: isInventory,
      hideSelectGroup: isInventory
    })
  });
};
const HeaderLinkAddDataRoute = ({
  path,
  onboardingFlow,
  exact
}) => {
  const {
    share
  } = (0, _public.useKibana)().services;
  const onboardingLocator = share === null || share === void 0 ? void 0 : share.url.locators.get(_deeplinksObservability.OBSERVABILITY_ONBOARDING_LOCATOR);
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: path,
    exact: exact,
    render: () => /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
      href: onboardingLocator === null || onboardingLocator === void 0 ? void 0 : onboardingLocator.getRedirectUrl({
        category: onboardingFlow
      }),
      color: "primary",
      iconType: "indexOpen"
    }, ADD_DATA_LABEL)
  });
};