"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsTabContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _public = require("@kbn/observability-plugin/public");
var _reactHooks = require("@kbn/react-hooks");
var _constants = require("../../../../../../../common/constants");
var _use_kibana = require("../../../../../../hooks/use_kibana");
var _height_retainer = require("../../../../../../components/height_retainer");
var _use_unified_search = require("../../../hooks/use_unified_search");
var _use_alerts_query = require("../../../hooks/use_alerts_query");
var _constants2 = require("../../../../../../components/shared/alerts/constants");
var _alerts_status_filter = _interopRequireDefault(require("../../../../../../components/shared/alerts/alerts_status_filter"));
var _create_alert_rule_button = require("../../../../../../components/shared/alerts/links/create_alert_rule_button");
var _link_to_alerts_page = require("../../../../../../components/shared/alerts/links/link_to_alerts_page");
var _alert_flyout = require("../../../../../../alerting/inventory/components/alert_flyout");
var _plugin_config_context = require("../../../../../../containers/plugin_config_context");
var _use_hosts_view = require("../../../hooks/use_hosts_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertsTabContent = () => {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    featureFlags
  } = (0, _plugin_config_context.usePluginConfig)();
  const {
    hostNodes
  } = (0, _use_hosts_view.useHostsViewContext)();
  const {
    alertStatus,
    setAlertStatus,
    alertsEsQueryByStatus
  } = (0, _use_alerts_query.useAlertsQuery)();
  const [isAlertFlyoutVisible, {
    toggle: toggleAlertFlyout
  }] = (0, _reactHooks.useBoolean)(false);
  const {
    onDateRangeChange,
    searchCriteria
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const {
    triggersActionsUi
  } = services;
  const {
    alertsTableConfigurationRegistry,
    getAlertsStateTable: AlertsStateTable
  } = triggersActionsUi;
  const hostNamesKuery = hostNodes.map(host => `host.name: "${host.name}"`).join(' OR ');
  return /*#__PURE__*/_react.default.createElement(_height_retainer.HeightRetainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    "data-test-subj": "hostsView-alerts"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_alerts_status_filter.default, {
    onChange: setAlertStatus,
    status: alertStatus
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexEnd",
    responsive: false
  }, featureFlags.inventoryThresholdAlertRuleEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_create_alert_rule_button.CreateAlertRuleButton, {
    onClick: toggleAlertFlyout,
    "data-test-subj": "infraHostAlertsTabCreateAlertsRuleButton"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_link_to_alerts_page.LinkToAlertsPage, {
    dateRange: searchCriteria.dateRange,
    "data-test-subj": "infraHostAlertsTabAlertsShowAllButton",
    kuery: hostNamesKuery
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(MemoAlertSummaryWidget, {
    alertsQuery: alertsEsQueryByStatus,
    dateRange: searchCriteria.dateRange,
    onRangeSelection: onDateRangeChange
  })), alertsEsQueryByStatus && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(AlertsStateTable, {
    alertsTableConfigurationRegistry: alertsTableConfigurationRegistry,
    configurationId: _ruleDataUtils.AlertConsumers.OBSERVABILITY,
    ruleTypeIds: _ruleDataUtils.OBSERVABILITY_RULE_TYPE_IDS,
    consumers: _constants.INFRA_ALERT_CONSUMERS,
    id: _constants2.ALERTS_TABLE_ID,
    initialPageSize: _constants2.ALERTS_PER_PAGE,
    query: alertsEsQueryByStatus,
    showAlertStatusWithFlapping: true
  }))), featureFlags.inventoryThresholdAlertRuleEnabled && /*#__PURE__*/_react.default.createElement(_alert_flyout.AlertFlyout, {
    nodeType: "host",
    setVisible: toggleAlertFlyout,
    visible: isAlertFlyoutVisible
  }));
};
exports.AlertsTabContent = AlertsTabContent;
const MemoAlertSummaryWidget = /*#__PURE__*/_react.default.memo(({
  alertsQuery,
  dateRange,
  onRangeSelection
}) => {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const summaryTimeRange = (0, _public.useSummaryTimeRange)(dateRange);
  const {
    charts,
    triggersActionsUi
  } = services;
  const {
    getAlertSummaryWidget: AlertSummaryWidget
  } = triggersActionsUi;
  const onBrushEnd = brushEvent => {
    const {
      x
    } = brushEvent;
    if (x) {
      const [start, end] = x;
      const from = new Date(start).toISOString();
      const to = new Date(end).toISOString();
      onRangeSelection({
        from,
        to
      });
    }
  };
  const chartProps = {
    baseTheme: charts.theme.useChartsBaseTheme(),
    onBrushEnd
  };
  return /*#__PURE__*/_react.default.createElement(AlertSummaryWidget, {
    chartProps: chartProps,
    ruleTypeIds: _ruleDataUtils.OBSERVABILITY_RULE_TYPE_IDS,
    consumers: _constants.INFRA_ALERT_CONSUMERS,
    filter: alertsQuery,
    fullSize: true,
    timeRange: summaryTimeRange
  });
});