"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsOverview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-plugin/public");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _eui = require("@elastic/eui");
var _constants = require("../../../../common/constants");
var _use_kibana = require("../../../hooks/use_kibana");
var _create_alerts_es_query = require("../../../utils/filters/create_alerts_es_query");
var _constants2 = require("./constants");
var _alerts_status_filter = _interopRequireDefault(require("./alerts_status_filter"));
var _use_asset_details_url_state = require("../../asset_details/hooks/use_asset_details_url_state");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertsOverview = ({
  assetId,
  dateRange,
  onLoaded,
  onRangeSelection,
  assetType
}) => {
  var _urlState$alertStatus;
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const [urlState, setUrlState] = (0, _use_asset_details_url_state.useAssetDetailsUrlState)();
  const [alertStatus, setAlertStatus] = (0, _react.useState)((_urlState$alertStatus = urlState === null || urlState === void 0 ? void 0 : urlState.alertStatus) !== null && _urlState$alertStatus !== void 0 ? _urlState$alertStatus : _constants2.ALERT_STATUS_ALL);
  const {
    charts,
    triggersActionsUi: {
      getAlertsStateTable: AlertsStateTable,
      alertsTableConfigurationRegistry,
      getAlertSummaryWidget: AlertSummaryWidget
    }
  } = services;
  const baseTheme = charts.theme.useChartsBaseTheme();
  const alertsEsQueryByStatus = (0, _react.useMemo)(() => (0, _create_alerts_es_query.createAlertsEsQuery)({
    dateRange,
    assetIds: [assetId],
    status: alertStatus,
    assetType
  }), [dateRange, assetId, alertStatus, assetType]);
  const alertsEsQuery = (0, _react.useMemo)(() => (0, _create_alerts_es_query.createAlertsEsQuery)({
    dateRange,
    assetIds: [assetId],
    status: _constants2.ALERT_STATUS_ALL,
    assetType
  }), [assetId, assetType, dateRange]);
  const summaryTimeRange = (0, _public.useSummaryTimeRange)(dateRange);
  const onBrushEnd = (0, _react.useCallback)(brushEvent => {
    const {
      x
    } = brushEvent;
    if (x && onRangeSelection) {
      const [start, end] = x;
      const from = new Date(start).toISOString();
      const to = new Date(end).toISOString();
      onRangeSelection({
        from,
        to
      });
    }
  }, [onRangeSelection]);
  const chartProps = (0, _react.useMemo)(() => ({
    baseTheme,
    onBrushEnd
  }), [onBrushEnd, baseTheme]);
  const handleAlertStatusChange = id => {
    setAlertStatus(id);
    setUrlState({
      alertStatus: id
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    "data-test-subj": "hostsView-alerts"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_alerts_status_filter.default, {
    onChange: handleAlertStatusChange,
    status: alertStatus
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(AlertSummaryWidget, {
    chartProps: chartProps,
    ruleTypeIds: _ruleDataUtils.OBSERVABILITY_RULE_TYPE_IDS,
    consumers: _constants.INFRA_ALERT_CONSUMERS,
    filter: alertsEsQuery,
    timeRange: summaryTimeRange,
    onLoaded: onLoaded,
    fullSize: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(AlertsStateTable, {
    alertsTableConfigurationRegistry: alertsTableConfigurationRegistry,
    id: 'assetDetailsAlertsTable',
    configurationId: _ruleDataUtils.AlertConsumers.OBSERVABILITY,
    ruleTypeIds: _ruleDataUtils.OBSERVABILITY_RULE_TYPE_IDS,
    consumers: _constants.INFRA_ALERT_CONSUMERS,
    showAlertStatusWithFlapping: true,
    query: alertsEsQueryByStatus,
    initialPageSize: 5
  })));
};
exports.AlertsOverview = AlertsOverview;