"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Processes = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _ioTsUtils = require("@kbn/io-ts-utils");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _common2 = require("@kbn/observability-shared-plugin/common");
var _metrics_source = require("../../../../containers/metrics_source");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _parse_search_string = require("./parse_search_string");
var _processes_table = require("./processes_table");
var _states = require("./states");
var _summary_table = require("./summary_table");
var _use_process_list = require("../../hooks/use_process_list");
var _use_asset_details_render_props = require("../../hooks/use_asset_details_render_props");
var _use_date_picker = require("../../hooks/use_date_picker");
var _processes_explanation = require("../../components/processes_explanation");
var _use_asset_details_url_state = require("../../hooks/use_asset_details_url_state");
var _top_processes_tooltip = require("../../components/top_processes_tooltip");
var _http_api = require("../../../../../common/http_api");
var _use_request_observable = require("../../hooks/use_request_observable");
var _use_tab_switcher = require("../../hooks/use_tab_switcher");
var _add_metrics_callout = require("../../add_metrics_callout");
var _use_entity_summary = require("../../hooks/use_entity_summary");
var _get_data_stream_types = require("../../utils/get_data_stream_types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const options = Object.entries(_states.STATE_NAMES).map(([value, view]) => ({
  value,
  view
}));
const Processes = () => {
  var _urlState$processSear, _data$processList, _data$processList2;
  const ref = (0, _react.useRef)(null);
  const {
    getDateRangeInTimestamp
  } = (0, _use_date_picker.useDatePickerContext)();
  const [urlState, setUrlState] = (0, _use_asset_details_url_state.useAssetDetailsUrlState)();
  const {
    asset,
    renderMode
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const {
    sourceId
  } = (0, _metrics_source.useSourceContext)();
  const {
    request$
  } = (0, _use_request_observable.useRequestObservable)();
  const {
    isActiveTab
  } = (0, _use_tab_switcher.useTabSwitcherContext)();
  const {
    dataStreams,
    status: dataStreamsStatus
  } = (0, _use_entity_summary.useEntitySummary)({
    entityType: _common2.BUILT_IN_ENTITY_TYPES.HOST,
    entityId: asset.name,
    from: new Date(getDateRangeInTimestamp().from).toISOString(),
    to: new Date(getDateRangeInTimestamp().to).toISOString()
  });
  const addMetricsCalloutId = 'hostProcesses';
  const [dismissedAddMetricsCallout, setDismissedAddMetricsCallout] = (0, _useLocalStorage.default)(`infra.dismissedAddMetricsCallout.${addMetricsCalloutId}`, false);
  const [searchText, setSearchText] = (0, _react.useState)((_urlState$processSear = urlState === null || urlState === void 0 ? void 0 : urlState.processSearch) !== null && _urlState$processSear !== void 0 ? _urlState$processSear : '');
  const [searchQueryError, setSearchQueryError] = (0, _react.useState)(null);
  const [searchBarState, setSearchBarState] = (0, _react.useState)(() => searchText ? _eui.Query.parse(searchText) : _eui.Query.MATCH_ALL);
  const toTimestamp = (0, _react.useMemo)(() => getDateRangeInTimestamp().to, [getDateRangeInTimestamp]);
  const [sortBy, setSortBy] = (0, _react.useState)({
    name: 'cpu',
    isAscending: false
  });
  const hostTerm = (0, _react.useMemo)(() => {
    var _getFieldByType;
    const field = (_getFieldByType = (0, _common.getFieldByType)(asset.type)) !== null && _getFieldByType !== void 0 ? _getFieldByType : asset.type;
    return {
      [field]: asset.name
    };
  }, [asset.name, asset.type]);
  const searchFilter = (0, _react.useMemo)(() => (0, _parse_search_string.parseSearchString)(searchText), [searchText]);
  const parsedSortBy = (0, _react.useMemo)(() => sortBy.name === 'runtimeLength' ? {
    ...sortBy,
    name: 'startTime'
  } : sortBy, [sortBy]);
  const {
    data,
    status,
    error,
    refetch
  } = (0, _use_fetcher.useFetcher)(async callApi => {
    const response = await callApi('/api/metrics/process_list', {
      method: 'POST',
      body: JSON.stringify({
        hostTerm,
        sourceId,
        to: toTimestamp,
        sortBy: parsedSortBy,
        searchFilter
      })
    });
    return (0, _ioTsUtils.decodeOrThrow)(_http_api.ProcessListAPIResponseRT)(response);
  }, [hostTerm, parsedSortBy, searchFilter, sourceId, toTimestamp], {
    requestObservable$: request$,
    autoFetch: isActiveTab('processes')
  });
  const debouncedSearchOnChange = (0, _react.useMemo)(() => {
    return (0, _lodash.debounce)(queryText => {
      setSearchText(queryText);
    }, 500);
  }, []);
  const searchBarOnChange = (0, _react.useCallback)(({
    query,
    queryText,
    error: queryError
  }) => {
    if (queryError) {
      setSearchQueryError(queryError);
    } else {
      setUrlState({
        processSearch: queryText
      });
      setSearchQueryError(null);
      setSearchBarState(query);
      debouncedSearchOnChange(queryText);
    }
  }, [debouncedSearchOnChange, setUrlState]);
  const clearSearchBar = (0, _react.useCallback)(() => {
    setSearchBarState(_eui.Query.MATCH_ALL);
    setUrlState({
      processSearch: ''
    });
    setSearchQueryError(null);
    setSearchText('');
  }, [setUrlState]);
  const isLoading = (0, _use_fetcher.isPending)(status);
  const showAddMetricsCallout = dataStreamsStatus === 'success' && !(0, _get_data_stream_types.isMetricsSignal)(dataStreams) && !dismissedAddMetricsCallout && renderMode.mode === 'page';
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showAddMetricsCallout && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_add_metrics_callout.AddMetricsCallout, {
    id: addMetricsCalloutId,
    onDismiss: () => {
      setDismissedAddMetricsCallout(true);
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_use_process_list.ProcessListContextProvider, {
    hostTerm: hostTerm,
    to: toTimestamp
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    ref: ref
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_summary_table.SummaryTable, {
    isLoading: isLoading,
    processSummary: error || !(data !== null && data !== void 0 && data.summary) ? {
      total: 0
    } : data === null || data === void 0 ? void 0 : data.summary
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "data-test-subj": "infraAssetDetailsTopProcessesTitle",
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.metrics.nodeDetails.processesHeader",
    defaultMessage: "Top processes"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_top_processes_tooltip.TopProcessesTooltip, null))), !error && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null) : ((_data$processList = data === null || data === void 0 ? void 0 : data.processList) !== null && _data$processList !== void 0 ? _data$processList : []).length > 0 && /*#__PURE__*/_react.default.createElement(_processes_explanation.ProcessesExplanationMessage, null)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    query: searchBarState,
    onChange: searchBarOnChange,
    box: {
      'data-test-subj': 'infraAssetDetailsProcessesSearchBarInput',
      incremental: true,
      placeholder: _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.searchForProcesses', {
        defaultMessage: 'Search for processes…'
      })
    },
    filters: [{
      type: 'field_value_selection',
      field: 'state',
      name: 'State',
      operator: 'exact',
      multiSelect: false,
      options
    }]
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, !error ? /*#__PURE__*/_react.default.createElement(_processes_table.ProcessesTable, {
    currentTime: toTimestamp,
    isLoading: isLoading,
    processList: (_data$processList2 = data === null || data === void 0 ? void 0 : data.processList) !== null && _data$processList2 !== void 0 ? _data$processList2 : [],
    sortBy: sortBy,
    error: searchQueryError === null || searchQueryError === void 0 ? void 0 : searchQueryError.message,
    setSortBy: setSortBy,
    clearSearchBar: clearSearchBar
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.metrics.nodeDetails.processListError",
      defaultMessage: "Unable to load process data"
    })),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "infraAssetDetailsTabComponentTryAgainButton",
      color: "primary",
      fill: true,
      onClick: refetch
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.metrics.nodeDetails.processListRetry",
      defaultMessage: "Try again"
    }))
  })))));
};
exports.Processes = Processes;