"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyDashboards = EmptyDashboards;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sharedSvg = require("@kbn/shared-svg");
var _use_is_dark_mode = require("../../../../hooks/use_is_dark_mode");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EmptyDashboards({
  actions
}) {
  const isDarkMode = (0, _use_is_dark_mode.useIsDarkMode)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    hasShadow: false,
    hasBorder: false,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "fullWidth",
      src: isDarkMode ? _sharedSvg.dashboardsDark : _sharedSvg.dashboardsLight,
      alt: ""
    }),
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.infra.assetDetails.dashboards.emptyTitle', {
      defaultMessage: 'Want your own view?'
    })),
    layout: "horizontal",
    color: "plain",
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, _i18n.i18n.translate('xpack.infra.assetDetails.dashboards.emptyBody.first', {
      defaultMessage: 'Link your own dashboard to this view'
    })), /*#__PURE__*/_react.default.createElement("li", null, _i18n.i18n.translate('xpack.infra.assetDetails.dashboards.emptyBody.second', {
      defaultMessage: 'Provide the best visualizations relevant to your business'
    })), /*#__PURE__*/_react.default.createElement("li", null, _i18n.i18n.translate('xpack.infra.assetDetails.dashboards.emptyBody', {
      defaultMessage: 'Add or remove them at any time'
    }))), /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.infra.assetDetails.dashboards.emptyBody.getStarted', {
      defaultMessage: 'To get started, add your dashboard'
    }))),
    actions: actions
  });
}