"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Dashboards = Dashboards;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/dashboard-plugin/public");
var _common = require("@kbn/observability-shared-plugin/common");
var _reactRouterDom = require("react-router-dom");
var _rison = require("@kbn/rison");
var _lodash = require("lodash");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_kibana = require("../../../../hooks/use_kibana");
var _build = require("../../../../utils/filters/build");
var _empty_dashboards = require("./empty_dashboards");
var _actions = require("./actions");
var _use_fetch_custom_dashboards = require("../../hooks/use_fetch_custom_dashboards");
var _use_date_picker = require("../../hooks/use_date_picker");
var _use_asset_details_render_props = require("../../hooks/use_asset_details_render_props");
var _use_dashboards_fetcher = require("../../hooks/use_dashboards_fetcher");
var _use_data_views = require("../../hooks/use_data_views");
var _dashboard_selector = require("./dashboard_selector");
var _context_menu = require("./context_menu");
var _use_asset_details_url_state = require("../../hooks/use_asset_details_url_state");
var _filter_explanation_callout = require("./filter_explanation_callout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Dashboards() {
  const {
    dateRange
  } = (0, _use_date_picker.useDatePickerContext)();
  const {
    asset,
    renderMode
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const location = (0, _reactRouterDom.useLocation)();
  const {
    services: {
      share,
      telemetry
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const [dashboard, setDashboard] = (0, _react.useState)();
  const [customDashboards, setCustomDashboards] = (0, _react.useState)([]);
  const [currentDashboard, setCurrentDashboard] = (0, _react.useState)();
  const [trackingEventProperties, setTrackingEventProperties] = (0, _react.useState)({});
  const {
    data: allAvailableDashboards,
    status
  } = (0, _use_dashboards_fetcher.useDashboardFetcher)();
  const {
    metrics
  } = (0, _use_data_views.useDataViewsContext)();
  const [urlState, setUrlState] = (0, _use_asset_details_url_state.useAssetDetailsUrlState)();
  const trackOnlyOnceTheSameDashboardFilters = _react.default.useRef(false);
  const {
    dashboards,
    loading,
    reload
  } = (0, _use_fetch_custom_dashboards.useFetchCustomDashboards)({
    assetType: asset.type
  });
  (0, _react.useEffect)(() => {
    trackOnlyOnceTheSameDashboardFilters.current = false;
    if (currentDashboard) {
      const currentEventTrackingProperties = {
        assetType: asset.type,
        state: currentDashboard.dashboardFilterAssetIdEnabled,
        filtered_by: currentDashboard.dashboardFilterAssetIdEnabled ? ['assetId'] : []
      };
      if ((0, _lodash.isEqual)(trackingEventProperties, currentEventTrackingProperties)) {
        trackOnlyOnceTheSameDashboardFilters.current = true;
        return;
      }
      setTrackingEventProperties(currentEventTrackingProperties);
      if (!trackOnlyOnceTheSameDashboardFilters.current) {
        telemetry.reportAssetDashboardLoaded(currentEventTrackingProperties);
      }
    }
  }, [asset.type, currentDashboard, telemetry, trackingEventProperties]);
  (0, _react.useEffect)(() => {
    var _dashboards$reduce;
    const allAvailableDashboardsMap = new Map();
    allAvailableDashboards.forEach(availableDashboard => {
      allAvailableDashboardsMap.set(availableDashboard.id, availableDashboard);
    });
    const filteredCustomDashboards = (_dashboards$reduce = dashboards === null || dashboards === void 0 ? void 0 : dashboards.reduce((result, customDashboard) => {
      const matchedDashboard = allAvailableDashboardsMap.get(customDashboard.dashboardSavedObjectId);
      if (matchedDashboard) {
        result.push({
          title: matchedDashboard.attributes.title,
          ...customDashboard
        });
      }
      return result;
    }, [])) !== null && _dashboards$reduce !== void 0 ? _dashboards$reduce : [];
    setCustomDashboards(filteredCustomDashboards);
    // set a default dashboard if there is no selected dashboard
    if (!(urlState !== null && urlState !== void 0 && urlState.dashboardId)) {
      var _currentDashboard$das, _filteredCustomDashbo;
      setUrlState({
        dashboardId: (_currentDashboard$das = currentDashboard === null || currentDashboard === void 0 ? void 0 : currentDashboard.dashboardSavedObjectId) !== null && _currentDashboard$das !== void 0 ? _currentDashboard$das : (_filteredCustomDashbo = filteredCustomDashboards[0]) === null || _filteredCustomDashbo === void 0 ? void 0 : _filteredCustomDashbo.dashboardSavedObjectId
      });
    }
  }, [allAvailableDashboards, currentDashboard === null || currentDashboard === void 0 ? void 0 : currentDashboard.dashboardSavedObjectId, dashboards, setUrlState, urlState === null || urlState === void 0 ? void 0 : urlState.dashboardId]);
  const getCreationOptions = (0, _react.useCallback)(() => {
    const getInitialInput = () => ({
      viewMode: _public.ViewMode.VIEW,
      timeRange: {
        from: dateRange.from,
        to: dateRange.to
      }
    });
    return Promise.resolve({
      getInitialInput
    });
  }, [dateRange.from, dateRange.to]);
  (0, _react.useEffect)(() => {
    if (!dashboard) return;
    dashboard.setFilters(metrics.dataView && currentDashboard !== null && currentDashboard !== void 0 && currentDashboard.dashboardFilterAssetIdEnabled ? (0, _build.buildAssetIdFilter)(asset.name, asset.type, metrics.dataView) : []);
    dashboard.setTimeRange({
      from: dateRange.from,
      to: dateRange.to
    });
    dashboard.forceRefresh();
  }, [metrics.dataView, asset.name, dashboard, dateRange.from, dateRange.to, currentDashboard, asset.type]);
  const getLocatorParams = (0, _react.useCallback)((params, isFlyoutView) => {
    const searchParams = new URLSearchParams(location.search);
    const tableProperties = searchParams.get('tableProperties');
    const flyoutParams = isFlyoutView && tableProperties ? {
      tableProperties: (0, _rison.decode)(tableProperties)
    } : {};
    return {
      assetDetails: {
        ...urlState,
        dashboardId: params.dashboardId
      },
      assetType: asset.type,
      assetId: asset.id,
      ...flyoutParams
    };
  }, [asset.id, asset.type, location.search, urlState]);
  const locator = (0, _react.useMemo)(() => {
    const isFlyoutView = renderMode.mode === 'flyout';
    const baseLocator = share.url.locators.get(isFlyoutView ? _common.ASSET_DETAILS_FLYOUT_LOCATOR_ID : _common.ASSET_DETAILS_LOCATOR_ID);
    if (!baseLocator) return;
    return {
      ...baseLocator,
      getRedirectUrl: params => baseLocator.getRedirectUrl(getLocatorParams(params, isFlyoutView)),
      navigate: params => baseLocator.navigate(getLocatorParams(params, isFlyoutView))
    };
  }, [renderMode.mode, share.url.locators, getLocatorParams]);
  if ((loading || (0, _use_fetcher.isPending)(status)) && !(dashboards !== null && dashboards !== void 0 && dashboards.length)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
        logo: "logoObservability",
        size: "xl"
      }),
      title: /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.infra.customDashboards.loadingCustomDashboards', {
        defaultMessage: 'Loading dashboard'
      }))
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, !!(dashboards !== null && dashboards !== void 0 && dashboards.length) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, currentDashboard === null || currentDashboard === void 0 ? void 0 : currentDashboard.title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_dashboard_selector.DashboardSelector, {
    currentDashboardId: urlState === null || urlState === void 0 ? void 0 : urlState.dashboardId,
    customDashboards: customDashboards,
    setCurrentDashboard: setCurrentDashboard,
    onRefresh: reload
  })), currentDashboard && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_context_menu.ContextMenu, {
    items: [/*#__PURE__*/_react.default.createElement(_actions.LinkDashboard, {
      newDashboardButton: true,
      onRefresh: reload,
      customDashboards: customDashboards,
      assetType: asset.type
    }), /*#__PURE__*/_react.default.createElement(_actions.GotoDashboardLink, {
      currentDashboard: currentDashboard
    }), /*#__PURE__*/_react.default.createElement(_actions.EditDashboard, {
      currentDashboard: currentDashboard,
      onRefresh: reload,
      assetType: asset.type
    }), /*#__PURE__*/_react.default.createElement(_actions.UnlinkDashboard, {
      currentDashboard: currentDashboard,
      onRefresh: reload,
      assetType: asset.type
    })]
  }))), currentDashboard && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_filter_explanation_callout.FilterExplanationCallout, {
    dashboardFilterAssetIdEnabled: currentDashboard.dashboardFilterAssetIdEnabled
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), (urlState === null || urlState === void 0 ? void 0 : urlState.dashboardId) && /*#__PURE__*/_react.default.createElement(_public2.DashboardRenderer, {
    savedObjectId: urlState === null || urlState === void 0 ? void 0 : urlState.dashboardId,
    getCreationOptions: getCreationOptions,
    onApiAvailable: setDashboard,
    locator: locator
  }))) : /*#__PURE__*/_react.default.createElement(_empty_dashboards.EmptyDashboards, {
    actions: /*#__PURE__*/_react.default.createElement(_actions.LinkDashboard, {
      onRefresh: reload,
      customDashboards: customDashboards,
      assetType: asset.type
    })
  }));
}