"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TypeSwitcher = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _types = require("../../../../../common/alerting/logs/log_threshold/types");
var _editor = require("./editor");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const typePrefix = _i18n.i18n.translate('xpack.infra.logs.alertFlyout.thresholdTypePrefix', {
  defaultMessage: 'when the'
});
const countSuffix = _i18n.i18n.translate('xpack.infra.logs.alertFlyout.thresholdTypeCountSuffix', {
  defaultMessage: 'of log entries'
});
const ratioSuffix = _i18n.i18n.translate('xpack.infra.logs.alertFlyout.thresholdTypeRatioSuffix', {
  defaultMessage: 'of Query A to Query B'
});
const countI18n = _i18n.i18n.translate('xpack.infra.logs.alertFlyout.thresholdTypeCount', {
  defaultMessage: 'count'
});
const ratioI18n = _i18n.i18n.translate('xpack.infra.logs.alertFlyout.thresholdTypeRatio', {
  defaultMessage: 'ratio'
});
const getOptions = () => {
  return [{
    value: 'ratio',
    text: ratioI18n
  }, {
    value: 'count',
    text: countI18n
  }];
};
const getThresholdType = criteria => {
  return (0, _types.isRatioRule)(criteria) ? 'ratio' : 'count';
};
const TypeSwitcher = ({
  criteria,
  updateType
}) => {
  const [isThresholdTypePopoverOpen, setThresholdTypePopoverOpenState] = (0, _react.useState)(false);
  const thresholdType = getThresholdType(criteria);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "thresholdType",
    button: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      description: typePrefix,
      uppercase: true,
      value: thresholdType === 'ratio' ? ratioI18n : countI18n,
      isActive: isThresholdTypePopoverOpen,
      onClick: () => setThresholdTypePopoverOpenState(!isThresholdTypePopoverOpen)
    }), /*#__PURE__*/_react.default.createElement(_editor.ExpressionLike, {
      text: thresholdType === 'ratio' ? ratioSuffix.toUpperCase() : countSuffix.toUpperCase()
    })),
    isOpen: isThresholdTypePopoverOpen,
    closePopover: () => setThresholdTypePopoverOpenState(false),
    ownFocus: true,
    panelPaddingSize: "s",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "infraTypeSwitcherSelect",
    compressed: true,
    value: thresholdType,
    onChange: e => updateType(thresholdType === 'ratio' ? 'count' : 'ratio'),
    options: getOptions()
  }))))));
};
exports.TypeSwitcher = TypeSwitcher;