"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InfraMetadataRequestRT = exports.InfraMetadataRT = exports.InfraMetadataProjectRT = exports.InfraMetadataOSRT = exports.InfraMetadataMachineRT = exports.InfraMetadataInstanceRT = exports.InfraMetadataInfoResponseRT = exports.InfraMetadataInfoRT = exports.InfraMetadataHostRT = exports.InfraMetadataFeatureRT = exports.InfraMetadataContainerRT = exports.InfraMetadataCloudRT = exports.InfraMetadataAgentRT = exports.InfraMetadataAccountRT = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _common = require("@kbn/metrics-data-access-plugin/common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InfraMetadataRequestRT = exports.InfraMetadataRequestRT = rt.type({
  nodeId: rt.string,
  nodeType: _common.ItemTypeRT,
  sourceId: rt.string,
  timeRange: rt.type({
    from: rt.number,
    to: rt.number
  })
});
const InfraMetadataFeatureRT = exports.InfraMetadataFeatureRT = rt.type({
  name: rt.string,
  source: rt.string
});
const InfraMetadataOSRT = exports.InfraMetadataOSRT = rt.partial({
  codename: rt.string,
  family: rt.string,
  kernel: rt.string,
  name: rt.string,
  platform: rt.string,
  version: rt.string,
  build: rt.string
});
const InfraMetadataHostRT = exports.InfraMetadataHostRT = rt.partial({
  name: rt.string,
  hostname: rt.string,
  id: rt.string,
  ip: rt.union([rt.array(rt.string), rt.string]),
  mac: rt.union([rt.array(rt.string), rt.string]),
  os: InfraMetadataOSRT,
  architecture: rt.string,
  containerized: rt.boolean
});
const InfraMetadataContainerRT = exports.InfraMetadataContainerRT = rt.partial({
  name: rt.string,
  id: rt.string,
  runtime: rt.string,
  image: rt.partial({
    name: rt.string
  })
});
const InfraMetadataInstanceRT = exports.InfraMetadataInstanceRT = rt.partial({
  id: rt.string,
  name: rt.string
});
const InfraMetadataAccountRT = exports.InfraMetadataAccountRT = rt.partial({
  id: rt.string,
  name: rt.string
});
const InfraMetadataProjectRT = exports.InfraMetadataProjectRT = rt.partial({
  id: rt.string
});
const InfraMetadataMachineRT = exports.InfraMetadataMachineRT = rt.partial({
  interface: rt.string,
  type: rt.string
});
const InfraMetadataCloudRT = exports.InfraMetadataCloudRT = rt.partial({
  instance: InfraMetadataInstanceRT,
  provider: rt.string,
  account: InfraMetadataAccountRT,
  availability_zone: rt.string,
  project: InfraMetadataProjectRT,
  machine: InfraMetadataMachineRT,
  region: rt.string,
  imageId: rt.string
});
const InfraMetadataAgentRT = exports.InfraMetadataAgentRT = rt.partial({
  id: rt.string,
  version: rt.string,
  policy: rt.string
});
const InfraMetadataInfoRT = exports.InfraMetadataInfoRT = rt.partial({
  cloud: InfraMetadataCloudRT,
  host: InfraMetadataHostRT,
  container: InfraMetadataContainerRT,
  agent: InfraMetadataAgentRT,
  '@timestamp': rt.string
});
const InfraMetadataInfoResponseRT = exports.InfraMetadataInfoResponseRT = rt.partial({
  cloud: InfraMetadataCloudRT,
  host: InfraMetadataHostRT,
  container: InfraMetadataContainerRT,
  agent: InfraMetadataAgentRT,
  timestamp: rt.string
});
const InfraMetadataRequiredRT = rt.type({
  id: rt.string,
  name: rt.string,
  features: rt.array(InfraMetadataFeatureRT)
});
const InfraMetadataOptionalRT = rt.partial({
  info: InfraMetadataInfoResponseRT,
  hasSystemIntegration: rt.boolean
});
const InfraMetadataRT = exports.InfraMetadataRT = rt.intersection([InfraMetadataRequiredRT, InfraMetadataOptionalRT]);