"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createInferenceClient = createInferenceClient;
var _chat_complete = require("../chat_complete");
var _create_output_api = require("../../common/output/create_output_api");
var _get_connector_by_id = require("../util/get_connector_by_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createInferenceClient({
  request,
  actions,
  logger
}) {
  const chatComplete = (0, _chat_complete.createChatCompleteApi)({
    request,
    actions,
    logger
  });
  return {
    chatComplete,
    output: (0, _create_output_api.createOutputApi)(chatComplete),
    getConnectorById: async connectorId => {
      const actionsClient = await actions.getActionsClientWithRequest(request);
      return await (0, _get_connector_by_id.getConnectorById)({
        connectorId,
        actionsClient
      });
    }
  };
}