"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.chunksIntoMessage = chunksIntoMessage;
var _inferenceCommon = require("@kbn/inference-common");
var _rxjs = require("rxjs");
var _validate_tool_calls = require("../../util/validate_tool_calls");
var _merge_chunks = require("./merge_chunks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function chunksIntoMessage({
  logger,
  toolOptions
}) {
  return chunks$ => {
    const shared$ = chunks$.pipe((0, _rxjs.share)());
    return (0, _rxjs.merge)(shared$, shared$.pipe((0, _inferenceCommon.withoutTokenCountEvents)(), (0, _rxjs.toArray)(), (0, _rxjs.map)(chunks => {
      const concatenatedChunk = (0, _merge_chunks.mergeChunks)(chunks);
      logger.debug(() => `Received completed message: ${JSON.stringify(concatenatedChunk)}`);
      const {
        content,
        tool_calls: toolCalls
      } = concatenatedChunk;
      const validatedToolCalls = (0, _validate_tool_calls.validateToolCalls)({
        ...toolOptions,
        toolCalls
      });
      return {
        type: _inferenceCommon.ChatCompletionEventType.ChatCompletionMessage,
        content,
        toolCalls: validatedToolCalls
      };
    })));
  };
}