"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openAIAdapter = void 0;
var _rxjs = require("rxjs");
var _stream = require("stream");
var _inferenceCommon = require("@kbn/inference-common");
var _event_source_stream_into_observable = require("../../../util/event_source_stream_into_observable");
var _simulated_function_calling = require("../../simulated_function_calling");
var _function_calling_support = require("../../utils/function_calling_support");
var _to_openai = require("./to_openai");
var _process_openai_stream = require("./process_openai_stream");
var _emit_token_count_if_missing = require("./emit_token_count_if_missing");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const openAIAdapter = exports.openAIAdapter = {
  chatComplete: ({
    executor,
    system,
    messages,
    toolChoice,
    tools,
    temperature = 0,
    functionCalling = 'auto',
    modelName,
    logger,
    abortSignal,
    metadata
  }) => {
    const useSimulatedFunctionCalling = functionCalling === 'auto' ? !(0, _function_calling_support.isNativeFunctionCallingSupported)(executor.getConnector()) : functionCalling === 'simulated';
    let request;
    if (useSimulatedFunctionCalling) {
      const wrapped = (0, _simulated_function_calling.wrapWithSimulatedFunctionCalling)({
        system,
        messages,
        toolChoice,
        tools
      });
      request = {
        stream: true,
        temperature,
        model: modelName,
        messages: (0, _to_openai.messagesToOpenAI)({
          system: wrapped.system,
          messages: wrapped.messages
        })
      };
    } else {
      request = {
        stream: true,
        temperature,
        model: modelName,
        messages: (0, _to_openai.messagesToOpenAI)({
          system,
          messages
        }),
        tool_choice: (0, _to_openai.toolChoiceToOpenAI)(toolChoice),
        tools: (0, _to_openai.toolsToOpenAI)(tools)
      };
    }
    return (0, _rxjs.from)(executor.invoke({
      subAction: 'stream',
      subActionParams: {
        body: JSON.stringify(request),
        signal: abortSignal,
        stream: true,
        ...(metadata !== null && metadata !== void 0 && metadata.connectorTelemetry ? {
          telemetryMetadata: metadata.connectorTelemetry
        } : {})
      }
    })).pipe((0, _rxjs.switchMap)(response => {
      if (response.status === 'error') {
        return (0, _rxjs.throwError)(() => (0, _inferenceCommon.createInferenceInternalError)(`Error calling connector: ${response.serviceMessage}`, {
          rootError: response.serviceMessage
        }));
      }
      if ((0, _stream.isReadable)(response.data)) {
        return (0, _event_source_stream_into_observable.eventSourceStreamIntoObservable)(response.data);
      }
      return (0, _rxjs.throwError)(() => (0, _inferenceCommon.createInferenceInternalError)('Unexpected error', response.data));
    }), (0, _process_openai_stream.processOpenAIStream)(), (0, _emit_token_count_if_missing.emitTokenCountEstimateIfMissing)({
      request
    }), useSimulatedFunctionCalling ? (0, _simulated_function_calling.parseInlineFunctionCalls)({
      logger
    }) : _rxjs.identity);
  }
};