"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.inferenceAdapter = void 0;
var _rxjs = require("rxjs");
var _stream = require("stream");
var _inferenceCommon = require("@kbn/inference-common");
var _event_source_stream_into_observable = require("../../../util/event_source_stream_into_observable");
var _utils = require("../../utils");
var _simulated_function_calling = require("../../simulated_function_calling");
var _openai = require("../openai");
var _create_openai_request = require("./create_openai_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const inferenceAdapter = exports.inferenceAdapter = {
  chatComplete: ({
    executor,
    system,
    messages,
    toolChoice,
    tools,
    functionCalling,
    temperature,
    modelName,
    logger,
    abortSignal,
    metadata
  }) => {
    const useSimulatedFunctionCalling = functionCalling === 'auto' ? !(0, _utils.isNativeFunctionCallingSupported)(executor.getConnector()) : functionCalling === 'simulated';
    const request = (0, _create_openai_request.createRequest)({
      connector: executor.getConnector(),
      system,
      messages,
      toolChoice,
      tools,
      simulatedFunctionCalling: useSimulatedFunctionCalling,
      temperature,
      modelName
    });
    return (0, _rxjs.from)(executor.invoke({
      subAction: 'unified_completion_stream',
      subActionParams: {
        body: request,
        signal: abortSignal,
        ...(metadata !== null && metadata !== void 0 && metadata.connectorTelemetry ? {
          telemetryMetadata: metadata.connectorTelemetry
        } : {})
      }
    })).pipe((0, _rxjs.switchMap)(response => {
      if (response.status === 'error') {
        return (0, _rxjs.throwError)(() => (0, _inferenceCommon.createInferenceInternalError)(`Error calling connector: ${response.serviceMessage}`, {
          rootError: response.serviceMessage
        }));
      }
      if ((0, _stream.isReadable)(response.data)) {
        return (0, _event_source_stream_into_observable.eventSourceStreamIntoObservable)(response.data);
      }
      return (0, _rxjs.throwError)(() => (0, _inferenceCommon.createInferenceInternalError)('Unexpected error', response.data));
    }), (0, _openai.processOpenAIStream)(), (0, _openai.emitTokenCountEstimateIfMissing)({
      request
    }), useSimulatedFunctionCalling ? (0, _simulated_function_calling.parseInlineFunctionCalls)({
      logger
    }) : _rxjs.identity);
  }
};