"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bindChatComplete = bindChatComplete;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Bind chatComplete to the provided parameters,
 * returning a bound version of the API.
 */

function bindChatComplete(chatComplete, boundParams) {
  const {
    connectorId,
    functionCalling
  } = boundParams;
  return unboundParams => {
    const params = {
      ...unboundParams,
      connectorId,
      functionCalling
    };
    return chatComplete(params);
  };
}