"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexActionsContextMenu = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _flatten_panel_tree = require("../../../../lib/flatten_panel_tree");
var _constants = require("../../../../../../common/constants");
var _routing = require("../../../../services/routing");
var _app_context = require("../../../../app_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class IndexActionsContextMenu extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "closeConfirmModal", () => {
      this.setState({
        renderConfirmModal: null
      });
      this.props.resetSelection && this.props.resetSelection();
    });
    (0, _defineProperty2.default)(this, "confirmAction", isActionConfirmed => {
      this.setState({
        isActionConfirmed
      });
    });
    (0, _defineProperty2.default)(this, "onButtonClick", () => {
      this.setState(prevState => ({
        isPopoverOpen: !prevState.isPopoverOpen
      }));
    });
    (0, _defineProperty2.default)(this, "closePopoverAndExecute", func => {
      this.setState({
        isPopoverOpen: false,
        renderConfirmModal: false
      });
      func();
      this.props.resetSelection && this.props.resetSelection();
    });
    (0, _defineProperty2.default)(this, "closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "forcemergeSegmentsError", () => {
      const {
        forcemergeSegments
      } = this.state;
      if (!forcemergeSegments || forcemergeSegments.match(/^([1-9][0-9]*)?$/)) {
        return;
      } else {
        return _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.segmentsNumberErrorMessage', {
          defaultMessage: 'The number of segments must be greater than zero.'
        });
      }
    });
    (0, _defineProperty2.default)(this, "renderForcemergeSegmentsModal", () => {
      const {
        forcemergeIndices,
        indexNames
      } = this.props;
      const helpText = _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.forceMerge.forceMergeSegmentsHelpText', {
        defaultMessage: 'Merge the segments in an index until the number is reduced to this or fewer segments. The default is 1.'
      });
      const selectedIndexCount = indexNames.length;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
        title: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.forceMerge.confirmModal.modalTitle', {
          defaultMessage: 'Force merge'
        }),
        onCancel: this.closeConfirmModal,
        onConfirm: () => {
          if (!this.forcemergeSegmentsError()) {
            this.closePopoverAndExecute(() => {
              forcemergeIndices(this.state.forcemergeSegments);
              this.setState({
                forcemergeSegments: null,
                showForcemergeSegmentsModal: null
              });
            });
          }
        },
        cancelButtonText: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.forceMerge.confirmModal.cancelButtonText', {
          defaultMessage: 'Cancel'
        }),
        confirmButtonText: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.forceMerge.confirmModal.confirmButtonText', {
          defaultMessage: 'Force merge'
        })
      }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexActionsMenu.forceMerge.forceMergeDescription",
        defaultMessage: "You are about to force merge {selectedIndexCount, plural, one {this index} other {these indices} }:",
        values: {
          selectedIndexCount
        }
      })), /*#__PURE__*/_react.default.createElement("ul", null, indexNames.map(indexName => /*#__PURE__*/_react.default.createElement("li", {
        key: indexName
      }, indexName))), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.forceMerge.proceedWithCautionCallOutTitle', {
          defaultMessage: 'Proceed with caution!'
        }),
        color: "warning",
        iconType: "help"
      }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexActionsMenu.forceMerge.forceMergeWarningDescription",
        defaultMessage: " Don't force-merge indices to which you're still writing, or to which you'll write again in the future. Instead, rely on the automatic background merge process to perform merges as needed to keep the index running smoothly. If you write to a force-merged index then its performance may become much worse. "
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
        isInvalid: !!this.forcemergeSegmentsError(),
        error: this.forcemergeSegmentsError()
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.forceMerge.maximumNumberOfSegmentsFormRowLabel', {
          defaultMessage: 'Maximum number of segments per shard'
        }),
        helpText: helpText
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
        "data-test-subj": "indexActionsForcemergeNumSegments",
        onChange: event => {
          this.setState({
            forcemergeSegments: event.target.value
          });
        },
        min: 1,
        name: "maxNumberSegments"
      }))));
    });
    (0, _defineProperty2.default)(this, "renderConfirmDeleteModal", () => {
      const {
        deleteIndices,
        indexNames
      } = this.props;
      const selectedIndexCount = indexNames.length;
      const standardIndexModalBody = /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexActionsMenu.deleteIndex.deleteDescription",
        defaultMessage: "You are about to delete {selectedIndexCount, plural, one {this index} other {these indices} }:",
        values: {
          selectedIndexCount
        }
      })), /*#__PURE__*/_react.default.createElement("ul", null, indexNames.map(indexName => /*#__PURE__*/_react.default.createElement("li", {
        key: indexName
      }, indexName))), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexActionsMenu.deleteIndex.deleteWarningDescription",
        defaultMessage: "You can't recover a deleted index. Make sure you have appropriate backups."
      })));
      return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
        title: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.deleteIndex.confirmModal.modalTitle', {
          defaultMessage: 'Delete {selectedIndexCount, plural, one {index} other {# indices} }',
          values: {
            selectedIndexCount
          }
        }),
        onCancel: () => {
          this.confirmAction(false);
          this.closeConfirmModal();
        },
        onConfirm: () => this.closePopoverAndExecute(deleteIndices),
        buttonColor: "danger",
        confirmButtonDisabled: false,
        cancelButtonText: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.deleteIndex.confirmModal.cancelButtonText', {
          defaultMessage: 'Cancel'
        }),
        confirmButtonText: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.deleteIndex.confirmModal.confirmButtonText', {
          defaultMessage: 'Delete {selectedIndexCount, plural, one {index} other {indices} }',
          values: {
            selectedIndexCount
          }
        })
      }, standardIndexModalBody);
    });
    this.state = {
      isPopoverOpen: false,
      renderConfirmModal: null,
      isActionConfirmed: false
    };
  }
  panels() {
    const {
      services: {
        extensionsService
      },
      core: {
        getUrlForApp,
        application,
        http
      },
      history,
      config: {
        enableIndexActions
      }
    } = this.context;
    const {
      closeIndices,
      openIndices,
      flushIndices,
      refreshIndices,
      clearCacheIndices,
      isOnListView,
      indexNames,
      indexStatusByName,
      performExtensionAction,
      indices,
      reloadIndices,
      unfreezeIndices,
      indicesListURLParams
    } = this.props;
    const allOpen = (0, _lodash.every)(indexNames, indexName => {
      return indexStatusByName[indexName] === _constants.INDEX_OPEN;
    });
    const allFrozen = (0, _lodash.every)(indices, index => index.isFrozen);
    const selectedIndexCount = indexNames.length;
    const items = [];
    if (isOnListView && selectedIndexCount === 1) {
      items.push({
        'data-test-subj': 'showOverviewIndexMenuButton',
        name: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.showIndexOverviewLabel', {
          defaultMessage: 'Show index overview'
        }),
        onClick: () => {
          (0, _routing.navigateToIndexDetailsPage)(indexNames[0], indicesListURLParams, extensionsService, application, http, _constants.IndexDetailsSection.Overview);
        }
      });
      items.push({
        'data-test-subj': 'showSettingsIndexMenuButton',
        name: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.showIndexSettingsLabel', {
          defaultMessage: 'Show index settings'
        }),
        onClick: () => {
          (0, _routing.navigateToIndexDetailsPage)(indexNames[0], indicesListURLParams, extensionsService, application, http, _constants.IndexDetailsSection.Settings);
        }
      });
      items.push({
        'data-test-subj': 'showMappingsIndexMenuButton',
        name: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.showIndexMappingLabel', {
          defaultMessage: 'Show index mapping'
        }),
        onClick: () => {
          (0, _routing.navigateToIndexDetailsPage)(indexNames[0], indicesListURLParams, extensionsService, application, http, _constants.IndexDetailsSection.Mappings);
        }
      });
      if (allOpen && enableIndexActions) {
        items.push({
          'data-test-subj': 'showStatsIndexMenuButton',
          name: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.showIndexStatsLabel', {
            defaultMessage: 'Show index stats'
          }),
          onClick: () => {
            history.push((0, _routing.getIndexDetailsLink)(indexNames[0], indicesListURLParams, _constants.IndexDetailsSection.Stats));
          }
        });
      }
    }
    if (allOpen && enableIndexActions) {
      items.push({
        'data-test-subj': 'closeIndexMenuButton',
        name: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.closeIndexLabel', {
          defaultMessage: 'Close {selectedIndexCount, plural, one {index} other {indices} }',
          values: {
            selectedIndexCount
          }
        }),
        onClick: () => {
          this.closePopoverAndExecute(closeIndices);
        }
      });
      items.push({
        'data-test-subj': 'forcemergeIndexMenuButton',
        name: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.forceMergeIndexLabel', {
          defaultMessage: 'Force merge {selectedIndexCount, plural, one {index} other {indices} }',
          values: {
            selectedIndexCount
          }
        }),
        onClick: () => {
          this.closePopover();
          this.setState({
            renderConfirmModal: this.renderForcemergeSegmentsModal
          });
        }
      });
      items.push({
        'data-test-subj': 'refreshIndexMenuButton',
        name: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.refreshIndexLabel', {
          defaultMessage: 'Refresh {selectedIndexCount, plural, one {index} other {indices} }',
          values: {
            selectedIndexCount
          }
        }),
        onClick: () => {
          this.closePopoverAndExecute(refreshIndices);
        }
      });
      items.push({
        'data-test-subj': 'clearCacheIndexMenuButton',
        name: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.clearIndexCacheLabel', {
          defaultMessage: 'Clear {selectedIndexCount, plural, one {index} other {indices} } cache',
          values: {
            selectedIndexCount
          }
        }),
        onClick: () => {
          this.closePopoverAndExecute(clearCacheIndices);
        }
      });
      items.push({
        'data-test-subj': 'flushIndexMenuButton',
        name: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.flushIndexLabel', {
          defaultMessage: 'Flush {selectedIndexCount, plural, one {index} other {indices} }',
          values: {
            selectedIndexCount
          }
        }),
        onClick: () => {
          this.closePopoverAndExecute(flushIndices);
        }
      });
      if (allFrozen) {
        items.push({
          'data-test-subj': 'unfreezeIndexMenuButton',
          name: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.unfreezeIndexLabel', {
            defaultMessage: 'Unfreeze {selectedIndexCount, plural, one {index} other {indices} }',
            values: {
              selectedIndexCount
            }
          }),
          onClick: () => {
            this.closePopoverAndExecute(unfreezeIndices);
          }
        });
      }
    } else if (!allOpen && enableIndexActions) {
      items.push({
        'data-test-subj': 'openIndexMenuButton',
        name: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.openIndexLabel', {
          defaultMessage: 'Open {selectedIndexCount, plural, one {index} other {indices} }',
          values: {
            selectedIndexCount
          }
        }),
        onClick: () => {
          this.closePopoverAndExecute(openIndices);
        }
      });
    }
    items.push({
      'data-test-subj': 'deleteIndexMenuButton',
      name: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.deleteIndexLabel', {
        defaultMessage: 'Delete {selectedIndexCount, plural, one {index} other {indices} }',
        values: {
          selectedIndexCount
        }
      }),
      onClick: () => {
        this.closePopover();
        this.setState({
          renderConfirmModal: this.renderConfirmDeleteModal
        });
      }
    });
    extensionsService.actions.forEach(actionExtension => {
      const actionExtensionDefinition = actionExtension({
        indices,
        reloadIndices,
        getUrlForApp
      });
      if (actionExtensionDefinition) {
        const {
          buttonLabel,
          requestMethod,
          successMessage,
          renderConfirmModal
        } = actionExtensionDefinition;
        if (requestMethod) {
          items.push({
            name: buttonLabel,
            onClick: () => {
              this.closePopoverAndExecute(async () => {
                await performExtensionAction(requestMethod, successMessage);
              });
            }
          });
        } else {
          items.push({
            name: buttonLabel,
            onClick: () => {
              this.closePopover();
              this.setState({
                renderConfirmModal
              });
            }
          });
        }
      }
    });
    const panelTree = {
      id: 0,
      title: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.panelTitle', {
        defaultMessage: '{selectedIndexCount, plural, one {Index} other {Indices} } options',
        values: {
          selectedIndexCount
        }
      }),
      items
    };
    return (0, _flatten_panel_tree.flattenPanelTree)(panelTree);
  }
  render() {
    const {
      indexNames
    } = this.props;
    const selectedIndexCount = indexNames.length;
    const {
      iconSide = 'right',
      anchorPosition = 'rightUp',
      label = _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.manageButtonLabel', {
        defaultMessage: 'Manage {selectedIndexCount, plural, one {index} other {{selectedIndexCount} indices}}',
        values: {
          selectedIndexCount
        }
      }),
      iconType = 'arrowDown',
      fill = true,
      isLoading = false
    } = this.props;
    const panels = this.panels();
    const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "indexActionsContextMenuButton",
      iconSide: iconSide,
      "aria-label": _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.manageButtonAriaLabel', {
        defaultMessage: '{selectedIndexCount, plural, one {index} other {indices} } options',
        values: {
          selectedIndexCount
        }
      }),
      onClick: this.onButtonClick,
      iconType: iconType,
      fill: fill,
      isLoading: isLoading
    }, label);
    return /*#__PURE__*/_react.default.createElement("div", null, this.state.renderConfirmModal ? this.state.renderConfirmModal(this.closeConfirmModal) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "contextMenuIndices",
      button: button,
      isOpen: this.state.isPopoverOpen,
      closePopover: this.closePopover,
      panelPaddingSize: "none",
      anchorPosition: anchorPosition,
      repositionOnScroll: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
      "data-test-subj": "indexContextMenu",
      initialPanelId: 0,
      panels: panels
    })));
  }
}
exports.IndexActionsContextMenu = IndexActionsContextMenu;
(0, _defineProperty2.default)(IndexActionsContextMenu, "contextType", _app_context.AppContext);